/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import net.dongliu.requests.Cookie;
import net.dongliu.requests.RequestBuilder;

@ThreadSafe
public class Session {
    private Set<Cookie> cookies = Collections.emptySet();

    Session() {
    }

    synchronized void updateCookie(Set<Cookie> addCookies) {
        if (addCookies.isEmpty()) {
            return;
        }
        long now = System.currentTimeMillis();
        HashSet<Cookie> newCookies = new HashSet<Cookie>();
        for (Cookie cookie : this.cookies) {
            if (cookie.expired(now) || addCookies.contains(cookie)) continue;
            newCookies.add(cookie);
        }
        for (Cookie cookie : addCookies) {
            if (cookie.expired(now)) continue;
            newCookies.add(cookie);
        }
        this.cookies = Collections.unmodifiableSet(newCookies);
    }

    synchronized Set<Cookie> getCookies() {
        return this.cookies;
    }

    List<Cookie> matchedCookies(String protocol, String domain, String path) {
        long now = System.currentTimeMillis();
        ArrayList<Cookie> matched = new ArrayList<Cookie>();
        for (Cookie cookie : this.cookies) {
            if (!cookie.match(protocol, domain, path) || cookie.expired(now)) continue;
            matched.add(cookie);
        }
        return matched;
    }

    public RequestBuilder get(String url) {
        return new RequestBuilder(this).url(url).method("GET");
    }

    public RequestBuilder post(String url) {
        return new RequestBuilder(this).url(url).method("POST");
    }

    public RequestBuilder put(String url) {
        return new RequestBuilder(this).url(url).method("PUT");
    }

    public RequestBuilder head(String url) {
        return new RequestBuilder(this).url(url).method("HEAD");
    }

    public RequestBuilder delete(String url) {
        return new RequestBuilder(this).url(url).method("DELETE");
    }

    public RequestBuilder patch(String url) {
        return new RequestBuilder(this).url(url).method("PATCH");
    }

    public RequestBuilder newRequest(String method, String url) {
        return new RequestBuilder(this).url(url).method(method);
    }
}

