/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dongliu.requests.Cookie;
import net.dongliu.requests.Headers;
import net.dongliu.requests.Parameter;
import net.dongliu.requests.Response;
import net.dongliu.requests.exception.RequestsException;
import net.dongliu.requests.json.JsonLookup;
import net.dongliu.requests.json.TypeInfer;
import net.dongliu.requests.utils.IOUtils;

public class RawResponse
implements AutoCloseable {
    private final int statusCode;
    private final String statusLine;
    private final Set<Cookie> cookies;
    private final Headers headers;
    private final InputStream input;
    private final HttpURLConnection conn;
    @Nullable
    private Charset charset;

    RawResponse(int statusCode, String statusLine, Headers headers, Set<Cookie> cookies, InputStream input, HttpURLConnection conn) {
        this.statusCode = statusCode;
        this.statusLine = statusLine;
        this.headers = headers;
        this.cookies = Collections.unmodifiableSet(cookies);
        this.input = input;
        this.conn = conn;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly(this.input);
        this.conn.disconnect();
    }

    @Deprecated
    public RawResponse withCharset(Charset charset) {
        this.charset = Objects.requireNonNull(charset);
        return this;
    }

    public RawResponse charset(Charset charset) {
        this.charset = Objects.requireNonNull(charset);
        return this;
    }

    /*
     * Exception decompiling
     */
    public String readToText() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Response<String> toTextResponse() {
        return new Response<String>(this.statusCode, this.cookies, this.headers, this.readToText());
    }

    public byte[] readToBytes() {
        try {
            byte[] byArray = IOUtils.readAll(this.input);
            return byArray;
        }
        catch (IOException e) {
            throw new RequestsException(e);
        }
        finally {
            this.close();
        }
    }

    public Response<byte[]> toBytesResponse() {
        return new Response<byte[]>(this.statusCode, this.cookies, this.headers, this.readToBytes());
    }

    public <T> T readToJson(Type type) {
        try {
            Object t = JsonLookup.getInstance().lookup().unmarshal(this.input, this.getCharset(), type);
            return t;
        }
        catch (IOException e) {
            throw new RequestsException(e);
        }
        finally {
            this.close();
        }
    }

    public <T> T readToJson(TypeInfer<T> typeInfer) {
        return this.readToJson(typeInfer.getType());
    }

    public <T> T readToJson(Class<T> cls) {
        return this.readToJson((Type)cls);
    }

    public <T> Response<T> toJsonResponse(TypeInfer<T> typeInfer) {
        return new Response<T>(this.statusCode, this.cookies, this.headers, this.readToJson(typeInfer));
    }

    public <T> Response<T> toJsonResponse(Class<T> cls) {
        return new Response<T>(this.statusCode, this.cookies, this.headers, this.readToJson(cls));
    }

    public void writeToFile(File file) {
        try (FileOutputStream os = new FileOutputStream(file);){
            IOUtils.copy(this.input, os);
        }
        catch (IOException e) {
            throw new RequestsException(e);
        }
        finally {
            this.close();
        }
    }

    public void writeToFile(Path path) {
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
            IOUtils.copy(this.input, os);
        }
        catch (IOException e) {
            throw new RequestsException(e);
        }
        finally {
            this.close();
        }
    }

    public void writeToFile(String path) {
        try (FileOutputStream os = new FileOutputStream(path);){
            IOUtils.copy(this.input, os);
        }
        catch (IOException e) {
            throw new RequestsException(e);
        }
        finally {
            this.close();
        }
    }

    public Response<File> toFileResponse(Path path) {
        File file = path.toFile();
        this.writeToFile(file);
        return new Response<File>(this.statusCode, this.cookies, this.headers, file);
    }

    public void writeTo(OutputStream out) {
        try {
            IOUtils.copy(this.input, out);
        }
        catch (IOException e) {
            throw new RequestsException(e);
        }
        finally {
            this.close();
        }
    }

    public void writeTo(Writer writer) {
        try (InputStreamReader reader = new InputStreamReader(this.input, this.getCharset());){
            IOUtils.copy(reader, writer);
        }
        catch (IOException e) {
            throw new RequestsException(e);
        }
        finally {
            this.close();
        }
    }

    public void discardBody() {
        try {
            IOUtils.skipAll(this.input);
        }
        catch (IOException e) {
            throw new RequestsException(e);
        }
        finally {
            this.close();
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusLine() {
        return this.statusLine;
    }

    public InputStream getInput() {
        return this.input;
    }

    @Nullable
    public String getFirstHeader(String name) {
        return this.headers.getFirstHeader(name);
    }

    @Nonnull
    public List<Parameter<String>> getHeaders() {
        return this.headers.getHeaders();
    }

    @Nonnull
    public List<String> getHeaders(String name) {
        return this.headers.getHeaders(name);
    }

    public Collection<Cookie> getCookies() {
        return this.cookies;
    }

    @Nullable
    public Cookie getFirstCookie(String name) {
        for (Cookie cookie : this.cookies) {
            if (!cookie.getName().equals(name)) continue;
            return cookie;
        }
        return null;
    }

    private Charset getCharset() {
        String[] items;
        if (this.charset != null) {
            return this.charset;
        }
        String contentType = this.getFirstHeader("Content-Type");
        if (contentType == null) {
            return StandardCharsets.UTF_8;
        }
        for (String item : items = contentType.split(";")) {
            String key;
            int idx;
            if ((item = item.trim()).isEmpty() || (idx = item.indexOf(61)) < 0 || !(key = item.substring(0, idx).trim()).equalsIgnoreCase("charset")) continue;
            return Charset.forName(item.substring(idx + 1).trim());
        }
        return StandardCharsets.UTF_8;
    }
}

