/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.requests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dongliu.requests.Parameter;

class Headers {
    private final List<Parameter<String>> headers;
    private final Map<String, List<String>> map;

    public Headers(List<Parameter<String>> headers) {
        this.headers = Collections.unmodifiableList(Objects.requireNonNull(headers));
        this.map = this.collectToMap(headers);
    }

    private Map<String, List<String>> collectToMap(List<? extends Map.Entry<String, String>> headers) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> entry : headers) {
            String key = entry.getKey().toLowerCase();
            String value = entry.getValue();
            ArrayList<String> list = (ArrayList<String>)map.get(key);
            if (list == null) {
                list = new ArrayList<String>(4);
                list.add(value);
                map.put(key, list);
                continue;
            }
            list.add(value);
        }
        return map;
    }

    @Nonnull
    public List<String> getHeaders(String name) {
        List<String> values = this.map.get(name.toLowerCase());
        if (values == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(values);
    }

    @Nullable
    public String getFirstHeader(String name) {
        List<String> values = this.map.get(name.toLowerCase());
        if (values == null) {
            return null;
        }
        return values.get(0);
    }

    public long getLongHeader(String name, long defaultValue) {
        String firstHeader = this.getFirstHeader(name);
        if (firstHeader == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(firstHeader.trim());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Nonnull
    public List<Parameter<String>> getHeaders() {
        return this.headers;
    }
}

