/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import redis.embedded.PortProvider;
import redis.embedded.Redis;
import redis.embedded.RedisCluster;
import redis.embedded.RedisSentinelBuilder;
import redis.embedded.RedisServer;
import redis.embedded.RedisServerBuilder;
import redis.embedded.ports.EphemeralPortProvider;
import redis.embedded.ports.PredefinedPortProvider;
import redis.embedded.ports.SequencePortProvider;

public class RedisClusterBuilder {
    private RedisSentinelBuilder sentinelBuilder = new RedisSentinelBuilder();
    private RedisServerBuilder serverBuilder = new RedisServerBuilder();
    private int sentinelCount = 1;
    private int quorumSize = 1;
    private PortProvider sentinelPortProvider = new SequencePortProvider(26379);
    private PortProvider replicationGroupPortProvider = new SequencePortProvider(6379);
    private final List<ReplicationGroup> groups = new LinkedList<ReplicationGroup>();

    public RedisClusterBuilder withSentinelBuilder(RedisSentinelBuilder sentinelBuilder) {
        this.sentinelBuilder = sentinelBuilder;
        return this;
    }

    public RedisClusterBuilder withServerBuilder(RedisServerBuilder serverBuilder) {
        this.serverBuilder = serverBuilder;
        return this;
    }

    public RedisClusterBuilder sentinelPorts(Collection<Integer> ports) {
        this.sentinelPortProvider = new PredefinedPortProvider(ports);
        this.sentinelCount = ports.size();
        return this;
    }

    public RedisClusterBuilder serverPorts(Collection<Integer> ports) {
        this.replicationGroupPortProvider = new PredefinedPortProvider(ports);
        return this;
    }

    public RedisClusterBuilder ephemeralSentinels() {
        this.sentinelPortProvider = new EphemeralPortProvider();
        return this;
    }

    public RedisClusterBuilder ephemeralServers() {
        this.replicationGroupPortProvider = new EphemeralPortProvider();
        return this;
    }

    public RedisClusterBuilder ephemeral() {
        this.ephemeralSentinels();
        this.ephemeralServers();
        return this;
    }

    public RedisClusterBuilder sentinelCount(int sentinelCount) {
        this.sentinelCount = sentinelCount;
        return this;
    }

    public RedisClusterBuilder sentinelStartingPort(int startingPort) {
        this.sentinelPortProvider = new SequencePortProvider(startingPort);
        return this;
    }

    public RedisClusterBuilder quorumSize(int quorumSize) {
        this.quorumSize = quorumSize;
        return this;
    }

    public RedisClusterBuilder replicationGroup(String masterName, int slaveCount) {
        this.groups.add(new ReplicationGroup(masterName, slaveCount, this.replicationGroupPortProvider));
        return this;
    }

    public RedisCluster build() {
        List<Redis> sentinels = this.buildSentinels();
        List<Redis> servers = this.buildServers();
        return new RedisCluster(sentinels, servers);
    }

    private List<Redis> buildServers() {
        ArrayList<Redis> servers = new ArrayList<Redis>();
        for (ReplicationGroup g : this.groups) {
            servers.add(this.buildMaster(g));
            this.buildSlaves(servers, g);
        }
        return servers;
    }

    private void buildSlaves(List<Redis> servers, ReplicationGroup g) {
        for (Integer slavePort : g.slavePorts) {
            this.serverBuilder.reset();
            this.serverBuilder.port(slavePort);
            this.serverBuilder.slaveOf("localhost", g.masterPort);
            RedisServer slave = this.serverBuilder.build();
            servers.add(slave);
        }
    }

    private Redis buildMaster(ReplicationGroup g) {
        this.serverBuilder.reset();
        return this.serverBuilder.port(g.masterPort).build();
    }

    private List<Redis> buildSentinels() {
        int toBuild = this.sentinelCount;
        LinkedList<Redis> sentinels = new LinkedList<Redis>();
        while (toBuild-- > 0) {
            sentinels.add(this.buildSentinel());
        }
        return sentinels;
    }

    private Redis buildSentinel() {
        this.sentinelBuilder.reset();
        this.sentinelBuilder.port(this.nextSentinelPort());
        for (ReplicationGroup g : this.groups) {
            this.sentinelBuilder.masterName(g.masterName);
            this.sentinelBuilder.masterPort(g.masterPort);
            this.sentinelBuilder.quorumSize(this.quorumSize);
            this.sentinelBuilder.addDefaultReplicationGroup();
        }
        return this.sentinelBuilder.build();
    }

    private int nextSentinelPort() {
        return this.sentinelPortProvider.next();
    }

    private static class ReplicationGroup {
        private final String masterName;
        private final int masterPort;
        private final List<Integer> slavePorts = new LinkedList<Integer>();

        private ReplicationGroup(String masterName, int slaveCount, PortProvider portProvider) {
            this.masterName = masterName;
            this.masterPort = portProvider.next();
            while (slaveCount-- > 0) {
                this.slavePorts.add(portProvider.next());
            }
        }
    }
}

