/*
 * Decompiled with CFR 0.152.
 */
package brave.http;

import brave.Span;
import brave.http.HttpAdapter;
import brave.http.HttpParser;
import brave.internal.Nullable;
import brave.propagation.CurrentTraceContext;
import zipkin2.Endpoint;

abstract class HttpHandler<Req, Resp, A extends HttpAdapter<Req, Resp>> {
    final CurrentTraceContext currentTraceContext;
    final A adapter;
    final HttpParser parser;

    HttpHandler(CurrentTraceContext currentTraceContext, A adapter, HttpParser parser) {
        this.currentTraceContext = currentTraceContext;
        this.adapter = adapter;
        this.parser = parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Span handleStart(Req request, Span span) {
        if (span.isNoop()) {
            return span;
        }
        CurrentTraceContext.Scope ws = this.currentTraceContext.maybeScope(span.context());
        try {
            this.parser.request(this.adapter, request, span.customizer());
            Endpoint.Builder remoteEndpoint = Endpoint.newBuilder();
            if (this.parseRemoteEndpoint(request, remoteEndpoint)) {
                span.remoteEndpoint(remoteEndpoint.build());
            }
        }
        finally {
            ws.close();
        }
        return span.start();
    }

    abstract boolean parseRemoteEndpoint(Req var1, Endpoint.Builder var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleFinish(@Nullable Resp response, @Nullable Throwable error, Span span) {
        if (span.isNoop()) {
            return;
        }
        try {
            CurrentTraceContext.Scope ws = this.currentTraceContext.maybeScope(span.context());
            try {
                this.parser.response(this.adapter, response, error, span.customizer());
            }
            finally {
                ws.close();
            }
        }
        finally {
            this.finishInNullScope(span);
        }
    }

    void finishInNullScope(Span span) {
        CurrentTraceContext.Scope ws = this.currentTraceContext.maybeScope(null);
        try {
            span.finish();
        }
        finally {
            ws.close();
        }
    }
}

