/*
 * Decompiled with CFR 0.152.
 */
package rx.subscriptions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import rx.Subscription;
import rx.exceptions.Exceptions;

public final class CompositeSubscription
implements Subscription {
    private Set<Subscription> subscriptions;
    private boolean unsubscribed = false;

    public CompositeSubscription() {
    }

    public CompositeSubscription(Subscription ... subscriptions) {
        this.subscriptions = new HashSet<Subscription>(Arrays.asList(subscriptions));
    }

    @Override
    public synchronized boolean isUnsubscribed() {
        return this.unsubscribed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Subscription s) {
        if (s.isUnsubscribed()) {
            return;
        }
        Subscription unsubscribe = null;
        CompositeSubscription compositeSubscription = this;
        synchronized (compositeSubscription) {
            if (this.unsubscribed) {
                unsubscribe = s;
            } else {
                if (this.subscriptions == null) {
                    this.subscriptions = new HashSet<Subscription>(4);
                }
                this.subscriptions.add(s);
            }
        }
        if (unsubscribe != null) {
            unsubscribe.unsubscribe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Subscription s) {
        boolean unsubscribe = false;
        CompositeSubscription compositeSubscription = this;
        synchronized (compositeSubscription) {
            if (this.unsubscribed || this.subscriptions == null) {
                return;
            }
            unsubscribe = this.subscriptions.remove(s);
        }
        if (unsubscribe) {
            s.unsubscribe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Set<Subscription> unsubscribe = null;
        CompositeSubscription compositeSubscription = this;
        synchronized (compositeSubscription) {
            if (this.unsubscribed || this.subscriptions == null) {
                return;
            }
            unsubscribe = this.subscriptions;
            this.subscriptions = null;
        }
        CompositeSubscription.unsubscribeFromAll(unsubscribe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe() {
        CompositeSubscription compositeSubscription = this;
        synchronized (compositeSubscription) {
            if (this.unsubscribed) {
                return;
            }
            this.unsubscribed = true;
        }
        CompositeSubscription.unsubscribeFromAll(this.subscriptions);
    }

    private static void unsubscribeFromAll(Collection<Subscription> subscriptions) {
        if (subscriptions == null) {
            return;
        }
        ArrayList<Throwable> es = null;
        for (Subscription s : subscriptions) {
            try {
                s.unsubscribe();
            }
            catch (Throwable e) {
                if (es == null) {
                    es = new ArrayList<Throwable>();
                }
                es.add(e);
            }
        }
        Exceptions.throwIfAny(es);
    }
}

