/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.search;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.search.MeterNotFoundException;
import io.micrometer.core.lang.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class RequiredSearch {
    private final MeterRegistry registry;
    private final List<Tag> tags = new ArrayList<Tag>();
    private Predicate<String> nameMatches = n -> true;
    private final Set<String> requiredTagKeys = new HashSet<String>();
    @Nullable
    private String exactNameMatch;

    private RequiredSearch(MeterRegistry registry) {
        this.registry = registry;
    }

    public RequiredSearch name(String exactName) {
        this.nameMatches = n -> n.equals(exactName);
        this.exactNameMatch = exactName;
        return this;
    }

    public RequiredSearch name(Predicate<String> nameMatches) {
        this.nameMatches = nameMatches;
        return this;
    }

    public RequiredSearch tags(Iterable<Tag> tags) {
        tags.forEach(this.tags::add);
        return this;
    }

    public RequiredSearch tags(String ... tags) {
        return this.tags(Tags.of(tags));
    }

    public RequiredSearch tag(String tagKey, String tagValue) {
        return this.tags(Tags.of(tagKey, tagValue));
    }

    public RequiredSearch tagKeys(String ... tagKeys) {
        this.requiredTagKeys.addAll(Arrays.asList(tagKeys));
        return this;
    }

    public Timer timer() {
        return this.findOne(Timer.class);
    }

    public Counter counter() {
        return this.findOne(Counter.class);
    }

    public Gauge gauge() {
        return this.findOne(Gauge.class);
    }

    public FunctionCounter functionCounter() {
        return this.findOne(FunctionCounter.class);
    }

    public TimeGauge timeGauge() {
        return this.findOne(TimeGauge.class);
    }

    public FunctionTimer functionTimer() {
        return this.findOne(FunctionTimer.class);
    }

    public DistributionSummary summary() {
        return this.findOne(DistributionSummary.class);
    }

    public LongTaskTimer longTaskTimer() {
        return this.findOne(LongTaskTimer.class);
    }

    public Meter meter() {
        return this.findOne(Meter.class);
    }

    private <M extends Meter> M findOne(Class<M> clazz) {
        Optional<Meter> meter = this.meters().stream().filter(clazz::isInstance).findAny().map(clazz::cast);
        if (meter.isPresent()) {
            return (M)meter.get();
        }
        throw new MeterNotFoundException(this.exactNameMatch, this.tags, clazz);
    }

    public Collection<Meter> meters() {
        List<Meter> meters;
        Stream<Meter> meterStream = this.registry.getMeters().stream().filter(m -> this.nameMatches.test(m.getId().getName()));
        if (!this.tags.isEmpty() || !this.requiredTagKeys.isEmpty()) {
            meterStream = meterStream.filter(m -> {
                boolean requiredKeysPresent = true;
                if (!this.requiredTagKeys.isEmpty()) {
                    ArrayList tagKeys = new ArrayList();
                    m.getId().getTags().forEach(t -> tagKeys.add(t.getKey()));
                    requiredKeysPresent = tagKeys.containsAll(this.requiredTagKeys);
                }
                return m.getId().getTags().containsAll(this.tags) && requiredKeysPresent;
            });
        }
        if ((meters = meterStream.collect(Collectors.toList())).isEmpty()) {
            throw new MeterNotFoundException(this.exactNameMatch, this.tags, Meter.class);
        }
        return meters;
    }

    public static RequiredSearch in(MeterRegistry registry) {
        return new RequiredSearch(registry);
    }
}

