/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.lombok.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.Modifier;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.StringBuilderSpinAllocator;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LombokLightModifierList
extends LightElement
implements PsiModifierList {
    private static final Set<String> MODIFIERS = new HashSet<String>(Arrays.asList("public", "packageLocal", "protected", "private", "final", "static", "abstract", "synchronized", "transient", "volatile", "native"));
    private final Set<String> myModifiers;
    private final PsiElement myParentElement;
    private final Map<String, PsiAnnotation> myAnnotations;

    public LombokLightModifierList(@NotNull PsiManager psiManager, @NotNull Language language, @NotNull PsiElement psiElement) {
        super(psiManager, language);
        this.myParentElement = psiElement;
        this.myModifiers = new HashSet<String>();
        this.myAnnotations = new HashMap<String, PsiAnnotation>();
    }

    public void addModifier(@Modifier @NotNull @NonNls String string) {
        this.myModifiers.add(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAllModifierProperties() {
        StringBuilder stringBuilder = StringBuilderSpinAllocator.alloc();
        try {
            for (String string : this.myModifiers) {
                if ("packageLocal".equals(string)) continue;
                stringBuilder.append(string).append(' ');
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)stringBuilder);
        }
    }

    public void clearModifiers() {
        this.myModifiers.clear();
    }

    public String getText() {
        return null;
    }

    public PsiElement copy() {
        return null;
    }

    public PsiElement getParent() {
        return this.myParentElement;
    }

    public PsiFile getContainingFile() {
        return this.myParentElement.getContainingFile();
    }

    public boolean hasModifierProperty(@Modifier @NotNull @NonNls String string) {
        return this.myModifiers.contains(string);
    }

    public boolean hasExplicitModifier(@Modifier @NotNull @NonNls String string) {
        return this.myModifiers.contains(string);
    }

    public void setModifierProperty(@Modifier @NotNull @NonNls String string, boolean bl) throws IncorrectOperationException {
        if (bl) {
            this.myModifiers.add(string);
        } else {
            this.myModifiers.remove(string);
        }
    }

    public void checkSetModifierProperty(@Modifier @NotNull @NonNls String string, boolean bl) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        return this.getAnnotations();
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String string) {
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
        PsiAnnotation psiAnnotation = psiElementFactory.createAnnotationFromText('@' + string, null);
        this.myAnnotations.put(string, psiAnnotation);
        return psiAnnotation;
    }

    public PsiAnnotation findAnnotation(@NotNull String string) {
        return this.myAnnotations.get(string);
    }

    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] psiAnnotationArray = PsiAnnotation.EMPTY_ARRAY;
        if (!this.myAnnotations.isEmpty()) {
            Collection<PsiAnnotation> collection = this.myAnnotations.values();
            psiAnnotationArray = collection.toArray(new PsiAnnotation[collection.size()]);
        }
        return psiAnnotationArray;
    }

    public void accept(@NotNull PsiElementVisitor psiElementVisitor) {
        if (psiElementVisitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)psiElementVisitor).visitModifierList((PsiModifierList)this);
        } else {
            psiElementVisitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "LombokLightModifierList";
    }
}

