/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.lombok.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.Modifier;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReceiver;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightIdentifier;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.presentation.java.JavaPresentationUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.ui.RowIcon;
import com.intellij.util.Icons;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.StringBuilderSpinAllocator;
import de.plushnikov.intellij.lombok.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.lombok.psi.LombokLightModifierList;
import de.plushnikov.intellij.lombok.psi.LombokLightParameter;
import de.plushnikov.intellij.lombok.psi.LombokLightParameterListBuilder;
import de.plushnikov.intellij.lombok.psi.LombokLightReferenceListBuilder;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LombokLightMethodBuilder9Impl
extends LightElement
implements LombokLightMethodBuilder {
    private ASTNode myASTNode;
    private final String myName;
    private final LombokLightModifierList myModifierList;
    private final LombokLightParameterListBuilder myParameterList;
    private final LombokLightReferenceListBuilder myThrowsList;
    private final LightIdentifier myNameIdentifier;
    private PsiType myReturnType;
    private Icon myBaseIcon;
    private PsiClass myContainingClass;
    private boolean myConstructor;
    protected PsiElement myNavigationElement;

    public LombokLightMethodBuilder9Impl(@NotNull PsiManager psiManager, @NotNull String string) {
        this(psiManager, StdLanguages.JAVA, string);
    }

    public LombokLightMethodBuilder9Impl(@NotNull PsiManager psiManager, @NotNull Language language, @NotNull String string) {
        super(psiManager, language);
        this.myName = string;
        this.myParameterList = new LombokLightParameterListBuilder(psiManager, language, (PsiMethod)this);
        this.myModifierList = new LombokLightModifierList(psiManager, language, (PsiElement)this);
        this.myThrowsList = new LombokLightReferenceListBuilder(psiManager, language, PsiReferenceList.Role.THROWS_LIST);
        this.myNameIdentifier = new LightIdentifier(psiManager, string);
        this.myNavigationElement = this;
    }

    public LombokLightMethodBuilder withNavigationElement(PsiElement psiElement) {
        this.setNavigationElement(psiElement);
        return this;
    }

    public LombokLightMethodBuilder withModifier(@Modifier @NotNull @NonNls String string) {
        this.myModifierList.addModifier(string);
        return this;
    }

    public LombokLightMethodBuilder withMethodReturnType(PsiType psiType) {
        this.myReturnType = psiType;
        if (null != this.myReturnType) {
            this.myConstructor = false;
        }
        return this;
    }

    public LombokLightMethodBuilder withParameter(@NotNull String string, @NotNull PsiType psiType) {
        this.myParameterList.addParameter(new LombokLightParameter(string, psiType, (PsiElement)this, StdLanguages.JAVA));
        return this;
    }

    public LombokLightMethodBuilder withException(@NotNull PsiClassType psiClassType) {
        this.myThrowsList.addReference(psiClassType);
        return this;
    }

    public LombokLightMethodBuilder withException(@NotNull String string) {
        this.myThrowsList.addReference(string);
        return this;
    }

    public PsiIdentifier getNameIdentifier() {
        return this.myNameIdentifier;
    }

    public LombokLightMethodBuilder setBaseIcon(Icon icon) {
        this.myBaseIcon = icon;
        return this;
    }

    public ItemPresentation getPresentation() {
        return JavaPresentationUtil.getMethodPresentation((PsiMethod)this);
    }

    public boolean hasTypeParameters() {
        return false;
    }

    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        return PsiTypeParameter.EMPTY_ARRAY;
    }

    @Nullable
    public PsiTypeParameterList getTypeParameterList() {
        return null;
    }

    @Nullable
    public PsiDocComment getDocComment() {
        return null;
    }

    public boolean isDeprecated() {
        return false;
    }

    public PsiElement setName(@NotNull String string) throws IncorrectOperationException {
        throw new UnsupportedOperationException("Please don't rename light methods");
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        return PsiSuperMethodImplUtil.getHierarchicalMethodSignature((PsiMethod)this);
    }

    @NotNull
    public PsiModifierList getModifierList() {
        return this.myModifierList;
    }

    public boolean hasModifierProperty(@NotNull String string) {
        return this.getModifierList().hasModifierProperty(string);
    }

    @Nullable
    public PsiType getReturnType() {
        return this.myReturnType;
    }

    @Nullable
    public PsiType getReturnTypeNoResolve() {
        return this.getReturnType();
    }

    @Nullable
    public PsiTypeElement getReturnTypeElement() {
        return null;
    }

    @NotNull
    public PsiParameterList getParameterList() {
        return this.myParameterList;
    }

    public LombokLightMethodBuilder9Impl setNavigationElement(PsiElement psiElement) {
        this.myNavigationElement = psiElement;
        return this;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        return this.myNavigationElement;
    }

    public LombokLightMethodBuilder withContainingClass(@NotNull PsiClass psiClass) {
        this.myContainingClass = psiClass;
        return this;
    }

    @NotNull
    public PsiReferenceList getThrowsList() {
        return this.myThrowsList;
    }

    public PsiCodeBlock getBody() {
        return null;
    }

    public boolean isConstructor() {
        return this.myConstructor;
    }

    public boolean isVarArgs() {
        return false;
    }

    @NotNull
    public MethodSignature getSignature(@NotNull PsiSubstitutor psiSubstitutor) {
        return MethodSignatureBackedByPsiMethod.create((PsiMethod)this, (PsiSubstitutor)psiSubstitutor);
    }

    public PsiClass getContainingClass() {
        return this.myContainingClass;
    }

    public PsiElement getParent() {
        PsiElement psiElement = super.getParent();
        psiElement = null != psiElement ? psiElement : this.getContainingClass();
        return psiElement;
    }

    @Nullable
    public PsiFile getContainingFile() {
        PsiClass psiClass = this.getContainingClass();
        return psiClass != null ? psiClass.getContainingFile() : null;
    }

    public String getText() {
        ASTNode aSTNode = this.getNode();
        if (null != aSTNode) {
            return aSTNode.getText();
        }
        return "";
    }

    public ASTNode getNode() {
        if (null == this.myASTNode) {
            this.myASTNode = this.rebuildMethodFromString().getNode();
        }
        return this.myASTNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PsiMethod rebuildMethodFromString() {
        StringBuilder stringBuilder = StringBuilderSpinAllocator.alloc();
        try {
            stringBuilder.append(((LombokLightModifierList)this.getModifierList()).getAllModifierProperties());
            PsiType psiType = this.getReturnType();
            if (null != psiType) {
                stringBuilder.append(psiType.getCanonicalText()).append(' ');
            }
            stringBuilder.append(this.getName());
            stringBuilder.append('(');
            if (this.getParameterList().getParametersCount() > 0) {
                for (PsiParameter psiParameter : this.getParameterList().getParameters()) {
                    stringBuilder.append(psiParameter.getType().getCanonicalText()).append(' ').append(psiParameter.getName()).append(',');
                }
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            stringBuilder.append(')');
            stringBuilder.append('{').append("  ").append('}');
            PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)this.getManager().getProject()).getElementFactory();
            PsiMethod psiMethod = psiElementFactory.createMethodFromText(stringBuilder.toString(), (PsiElement)this.getContainingClass());
            return psiMethod;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)stringBuilder);
        }
    }

    public PsiElement copy() {
        return this.rebuildMethodFromString();
    }

    public String toString() {
        return "LombokLightMethod: " + this.getName();
    }

    @NotNull
    public PsiMethod[] findSuperMethods() {
        return PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this);
    }

    @NotNull
    public PsiMethod[] findSuperMethods(boolean bl) {
        return PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, (boolean)bl);
    }

    @NotNull
    public PsiMethod[] findSuperMethods(PsiClass psiClass) {
        return PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, (PsiClass)psiClass);
    }

    @NotNull
    public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean bl) {
        return PsiSuperMethodImplUtil.findSuperMethodSignaturesIncludingStatic((PsiMethod)this, (boolean)bl);
    }

    public PsiMethod findDeepestSuperMethod() {
        return PsiSuperMethodImplUtil.findDeepestSuperMethod((PsiMethod)this);
    }

    @NotNull
    public PsiMethod[] findDeepestSuperMethods() {
        return PsiSuperMethodImplUtil.findDeepestSuperMethods((PsiMethod)this);
    }

    public void accept(@NotNull PsiElementVisitor psiElementVisitor) {
        if (psiElementVisitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)psiElementVisitor).visitMethod((PsiMethod)this);
        }
    }

    public Icon getElementIcon(int n) {
        Icon icon = this.myBaseIcon != null ? this.myBaseIcon : (this.hasModifierProperty("abstract") ? Icons.ABSTRACT_METHOD_ICON : Icons.METHOD_ICON);
        RowIcon rowIcon = LombokLightMethodBuilder9Impl.createLayeredIcon((Icon)icon, (int)ElementPresentationUtil.getFlags((PsiModifierListOwner)this, (boolean)false));
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, (int)n, (RowIcon)rowIcon);
    }

    public boolean isEquivalentTo(PsiElement psiElement) {
        return PsiClassImplUtil.isMethodEquivalentTo((PsiMethod)this, (PsiElement)psiElement);
    }

    @NotNull
    public SearchScope getUseScope() {
        return PsiImplUtil.getMemberUseScope((PsiMember)this);
    }

    public PsiElement getContext() {
        PsiElement psiElement = this.getNavigationElement();
        if (psiElement != this) {
            return psiElement;
        }
        PsiClass psiClass = this.getContainingClass();
        if (psiClass != null) {
            return psiClass;
        }
        return this.getContainingFile();
    }

    public PsiMethodReceiver getMethodReceiver() {
        return null;
    }

    public PsiElement replace(@NotNull PsiElement psiElement) throws IncorrectOperationException {
        PsiClass psiClass = this.getContainingClass();
        if (null != psiClass) {
            CheckUtil.checkWritable((PsiElement)psiClass);
            return psiClass.add(psiElement);
        }
        return null;
    }

    public void delete() throws IncorrectOperationException {
    }

    public void checkDelete() throws IncorrectOperationException {
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        LombokLightMethodBuilder9Impl lombokLightMethodBuilder9Impl = (LombokLightMethodBuilder9Impl)((Object)object);
        if (this.myConstructor != lombokLightMethodBuilder9Impl.myConstructor) {
            return false;
        }
        if (this.myBaseIcon != null ? !this.myBaseIcon.equals(lombokLightMethodBuilder9Impl.myBaseIcon) : lombokLightMethodBuilder9Impl.myBaseIcon != null) {
            return false;
        }
        if (this.myContainingClass != null ? !this.myContainingClass.equals(lombokLightMethodBuilder9Impl.myContainingClass) : lombokLightMethodBuilder9Impl.myContainingClass != null) {
            return false;
        }
        if (!((Object)((Object)this.myModifierList)).equals((Object)lombokLightMethodBuilder9Impl.myModifierList)) {
            return false;
        }
        if (!this.myName.equals(lombokLightMethodBuilder9Impl.myName)) {
            return false;
        }
        if (!((Object)((Object)this.myParameterList)).equals((Object)lombokLightMethodBuilder9Impl.myParameterList)) {
            return false;
        }
        return !(this.myReturnType != null ? !this.myReturnType.equals(lombokLightMethodBuilder9Impl.myReturnType) : lombokLightMethodBuilder9Impl.myReturnType != null);
    }

    public int hashCode() {
        int n = this.myName.hashCode();
        n = 31 * n + (this.myReturnType != null ? this.myReturnType.hashCode() : 0);
        n = 31 * n + ((Object)((Object)this.myModifierList)).hashCode();
        n = 31 * n + ((Object)((Object)this.myParameterList)).hashCode();
        n = 31 * n + (this.myBaseIcon != null ? this.myBaseIcon.hashCode() : 0);
        n = 31 * n + (this.myContainingClass != null ? this.myContainingClass.hashCode() : 0);
        n = 31 * n + (this.myConstructor ? 1 : 0);
        return n;
    }
}

