/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.lombok.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.Modifier;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LombokLightModifierList10Impl
extends LightModifierList {
    private static final Set<String> ALL_MODIFIERS = new HashSet<String>(Arrays.asList("public", "packageLocal", "protected", "private", "final", "static", "abstract", "synchronized", "transient", "volatile", "native"));
    private final Map<String, PsiAnnotation> myAnnotations = new HashMap<String, PsiAnnotation>();

    public LombokLightModifierList10Impl(PsiManager psiManager, Language language, String ... stringArray) {
        super(psiManager, language, stringArray);
    }

    public void setModifierProperty(@Modifier @NotNull @NonNls String string, boolean bl) throws IncorrectOperationException {
        if (bl) {
            this.addModifier(string);
        } else if (this.hasModifierProperty(string)) {
            this.removeModifier(string);
        }
    }

    private void removeModifier(@Modifier @NotNull @NonNls String string) {
        Collection<String> collection = this.collectAllModifiers();
        collection.remove(string);
        this.clearModifiers();
        for (String string2 : collection) {
            this.addModifier(string2);
        }
    }

    private Collection<String> collectAllModifiers() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : ALL_MODIFIERS) {
            if (!this.hasModifierProperty(string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public void checkSetModifierProperty(@Modifier @NotNull @NonNls String string, boolean bl) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String string) {
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
        PsiAnnotation psiAnnotation = psiElementFactory.createAnnotationFromText('@' + string, null);
        this.myAnnotations.put(string, psiAnnotation);
        return psiAnnotation;
    }

    public PsiAnnotation findAnnotation(@NotNull String string) {
        return this.myAnnotations.get(string);
    }

    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] psiAnnotationArray = PsiAnnotation.EMPTY_ARRAY;
        if (!this.myAnnotations.isEmpty()) {
            Collection<PsiAnnotation> collection = this.myAnnotations.values();
            psiAnnotationArray = collection.toArray(new PsiAnnotation[collection.size()]);
        }
        return psiAnnotationArray;
    }

    public String toString() {
        return "LombokLightModifierList10Impl";
    }
}

