/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.statement.server.repository;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ztesoft.zsmart.nros.common.model.enums.StatusEnum;
import com.ztesoft.zsmart.nros.sbc.statement.client.model.dto.StatementDTO;
import com.ztesoft.zsmart.nros.sbc.statement.client.model.query.StatementQuery;
import com.ztesoft.zsmart.nros.sbc.statement.server.common.convertor.StatementConvertor;
import com.ztesoft.zsmart.nros.sbc.statement.server.dao.dataobject.generator.StatementDO;
import com.ztesoft.zsmart.nros.sbc.statement.server.dao.mapper.StatementMapper;
import com.ztesoft.zsmart.nros.sbc.statement.server.dao.mapper.generator.StatementDOMapper;
import com.ztesoft.zsmart.nros.sbc.statement.server.domain.model.StatementBO;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class StatementRepository {
    @Autowired
    private StatementDOMapper statementDOMapper;
    @Autowired
    private StatementMapper statementMapper;
    @Autowired
    private StatementConvertor statementConvertor;

    public Long insertStatement(StatementBO statementBO) {
        StatementDO statementDO = this.statementConvertor.boToDO(statementBO);
        statementDO.setStatus(StatusEnum.ENABLE.getState());
        this.statementDOMapper.insert(statementDO);
        return statementDO.getId();
    }

    public Long deletedStatement(Long id) {
        StatementDO statementDO = new StatementDO();
        statementDO.setId(id);
        statementDO.setStatus(StatusEnum.DISABLE.getState());
        this.statementDOMapper.updateByPrimaryKeySelective(statementDO);
        return statementDO.getId();
    }

    public Long updateStatement(StatementBO statementBO) {
        StatementDO statementDO = this.statementConvertor.boToDO(statementBO);
        this.statementDOMapper.updateByPrimaryKeySelective(statementDO);
        return statementDO.getId();
    }

    public StatementDTO detailStatement(Long id) {
        StatementDO statementDODetail = this.statementDOMapper.selectByPrimaryKey(id);
        return this.statementConvertor.doToDTO(statementDODetail);
    }

    public PageInfo<StatementDTO> pageStatement(StatementQuery query) {
        PageHelper.startPage((int)query.getPageIndex(), (int)query.getPageSize());
        List<StatementDO> statementDOList = this.statementMapper.queryStatement(query);
        PageInfo statementInfoDOPageInfo = new PageInfo(statementDOList);
        return this.statementConvertor.doPageToDTOPage((PageInfo<StatementDO>)statementInfoDOPageInfo);
    }

    public List<StatementDTO> listStatement(StatementQuery query) {
        List<StatementDO> statementDOS = this.statementMapper.queryStatement(query);
        return this.statementConvertor.dosToDTOS(statementDOS);
    }

    public Long updateStatementStatusCheck(Long id) {
        return this.statementMapper.updateStatementCheck(id);
    }

    public Long updateStatementStatusRecord(Long id) {
        return this.statementMapper.updateStatementStatusRecord(id);
    }

    public Long updateStatementStatus(Long id, String statementStatus, Integer version) {
        return this.statementMapper.updateStatementStatus(id, statementStatus, version);
    }
}

