/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.statement.server.domain.middleware.mq.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.ztesoft.zsmart.nros.base.exception.BusiException;
import com.ztesoft.zsmart.nros.base.util.StringUtil;
import com.ztesoft.zsmart.nros.base.zmq.consumer.AbstractZMQHandler;
import com.ztesoft.zsmart.nros.base.zmq.entity.NrosMQMessage;
import com.ztesoft.zsmart.nros.sbc.statement.client.constants.enums.StatementStatusEnum;
import com.ztesoft.zsmart.nros.sbc.statement.client.model.dto.StatementDTO;
import com.ztesoft.zsmart.nros.sbc.statement.server.repository.StatementRepository;
import java.nio.charset.Charset;
import org.springframework.beans.factory.annotation.Autowired;

public class StatementStatusConsumer
extends AbstractZMQHandler {
    @Autowired
    private StatementRepository statementRepository;

    public Action doBusinesses(NrosMQMessage nrosMQMessage, ConsumeContext consumeContext) {
        try {
            this.logger.info("StatementStatusConsumer triggered...");
            Message msg = nrosMQMessage.getMqMessage();
            String msgBody = new String(msg.getBody(), Charset.forName("UTF-8"));
            this.logger.info("received message,msgBody={}", (Object)msgBody);
            JSONObject msgObject = JSON.parseObject((String)msgBody);
            String msgId = "process:ConsumedNrosMsgId:" + msgObject.getString("__nrosMsgIdInner__");
            Long statementId = StringUtil.parseLong((String)msgObject.getString("statementId"));
            if (statementId == null) {
                this.logger.error("Consume MQ message error! statementId is null! msgId=[{}]!", (Object)msgId);
                return Action.CommitMessage;
            }
            Long checkedId = this.statementRepository.updateStatementStatusCheck(statementId);
            if (checkedId == null) {
                StatementDTO statementDTO = this.statementRepository.detailStatement(statementId);
                Integer version = statementDTO.getVersion();
                String statementStatus = StatementStatusEnum.ALREADY_PAID.getIndex();
                this.statementRepository.updateStatementStatus(statementId, statementStatus, version);
                this.statementRepository.updateStatementStatusRecord(statementId);
                return Action.CommitMessage;
            }
        }
        catch (JSONException jsonException) {
            this.logger.error("Consume MQ message error! message content invalid!");
            return Action.CommitMessage;
        }
        catch (BusiException busiException) {
            this.logger.error("Consume MQ message error! message content invalid!");
            return Action.CommitMessage;
        }
        catch (Exception e) {
            this.logger.error("Consume MQ message error! msg={}!", (Object)e.getMessage());
            return Action.ReconsumeLater;
        }
        return null;
    }
}

