/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.statement.server.domain;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.ztesoft.zsmart.nros.base.exception.ExceptionHandler;
import com.ztesoft.zsmart.nros.base.model.ResponseMsg;
import com.ztesoft.zsmart.nros.base.util.DateUtil;
import com.ztesoft.zsmart.nros.base.util.SnowflakeIdWorker;
import com.ztesoft.zsmart.nros.sbc.statement.client.model.dto.ContractInfoDTO;
import com.ztesoft.zsmart.nros.sbc.statement.client.model.dto.RuleResultDTO;
import com.ztesoft.zsmart.nros.sbc.statement.client.model.dto.RuleResultDeductionDTO;
import com.ztesoft.zsmart.nros.sbc.statement.client.model.dto.StatementDTO;
import com.ztesoft.zsmart.nros.sbc.statement.client.model.dto.TotalAmountDTO;
import com.ztesoft.zsmart.nros.sbc.statement.client.model.param.RuleExecuteParam;
import com.ztesoft.zsmart.nros.sbc.statement.client.model.param.StatementParam;
import com.ztesoft.zsmart.nros.sbc.statement.client.model.query.StatementQuery;
import com.ztesoft.zsmart.nros.sbc.statement.server.common.convertor.StatementConvertor;
import com.ztesoft.zsmart.nros.sbc.statement.server.domain.feign.proxy.ContractProxy;
import com.ztesoft.zsmart.nros.sbc.statement.server.domain.feign.proxy.RuleProxy;
import com.ztesoft.zsmart.nros.sbc.statement.server.domain.model.StatementBO;
import com.ztesoft.zsmart.nros.sbc.statement.server.repository.StatementRepository;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StatementDomain {
    private static final Logger log = LoggerFactory.getLogger(StatementDomain.class);
    @Autowired
    private StatementRepository statementRepository;
    @Autowired
    private StatementConvertor statementConvertor;
    @Autowired
    private RuleProxy ruleProxy;
    @Autowired
    private ContractProxy contractProxy;

    public Boolean insertStatementCheck(StatementParam param) {
        Long contractId;
        String companyCode = param.getCompanyCode();
        if (companyCode == null) {
            ExceptionHandler.publish((String)"NROS-SBC-STATEMENT-0005");
        }
        if ((contractId = param.getContractId()) == null) {
            ExceptionHandler.publish((String)"NROS-SBC-STATEMENT-0003");
        }
        StatementQuery query = new StatementQuery();
        query.setContractId(contractId);
        List<StatementDTO> statementDTOS = this.statementRepository.listStatement(query);
        if (statementDTOS == null) {
            ExceptionHandler.publish((String)"NROS-SBC-OAUTH-0001");
        }
        RuleExecuteParam ruleExecuteParam = new RuleExecuteParam();
        JSONObject ruleParam = new JSONObject();
        ruleExecuteParam.setCode("53d8ec0e1bea11eaae330221860e9b7e");
        ruleExecuteParam.setCompanyCode(param.getCompanyCode());
        ruleParam.put("statementTimes", (Object)statementDTOS.size());
        ruleExecuteParam.setParams(ruleParam);
        ResponseMsg<RuleResultDTO> responseMsg = new ResponseMsg<RuleResultDTO>();
        try {
            responseMsg = this.ruleProxy.ruleExecute(ruleExecuteParam);
            RuleResultDTO ruleResult = (RuleResultDTO)responseMsg.getData();
            return ruleResult.getSuccess();
        }
        catch (Exception e) {
            log.error("rule execute exception,ruleExecuteParam is{},responseMsg is {}", new Object[]{ruleExecuteParam, responseMsg, e});
            return false;
        }
    }

    public Long insertStatement(StatementParam param) {
        String companyCode;
        BigDecimal contractAmount;
        Long contractId = param.getContractId();
        if (contractId == null) {
            ExceptionHandler.publish((String)"NROS-SBC-STATEMENT-0003");
        }
        if ((contractAmount = param.getContractAmount()) == null) {
            ExceptionHandler.publish((String)"NROS-SBC-STATEMENT-0004");
        }
        if ((companyCode = param.getCompanyCode()) == null) {
            ExceptionHandler.publish((String)"NROS-SBC-STATEMENT-0005");
        }
        StatementBO statementBO = this.statementConvertor.paramToBO(param);
        Date currentDate = new Date();
        statementBO.setStatementTime(currentDate);
        String statementMonth = DateUtil.dateToStr((Date)currentDate, (String)"yyyy-MM");
        statementBO.setStatementMonth(statementMonth);
        statementBO.setStatementCode(SnowflakeIdWorker.generateId().toString());
        RuleResultDTO resultDTO = this.foo(statementBO);
        if (resultDTO == null) {
            return null;
        }
        if (!resultDTO.getSuccess().booleanValue()) {
            ExceptionHandler.publish((String)"NROS-SBC-STATEMENT-0002", (String)resultDTO.getMessage());
        }
        RuleExecuteParam ruleExecuteParam = new RuleExecuteParam();
        JSONObject ruleParam = new JSONObject();
        ResponseMsg<RuleResultDTO> responseMsg = null;
        RuleResultDTO ruleResultDTO = null;
        ruleExecuteParam.setCompanyCode(statementBO.getCompanyCode());
        ruleExecuteParam.setCode("eeaafc97f8524b93aa325ec5e83a50ff");
        ruleParam.put("statementAmount", (Object)param.getStatementAmount());
        ruleParam.put("deductionAmount", (Object)param.getDeductionAmount());
        ruleParam.put("businessType", (Object)"1");
        ruleExecuteParam.setParams(ruleParam);
        try {
            responseMsg = this.ruleProxy.ruleExecute(ruleExecuteParam);
            ruleResultDTO = (RuleResultDTO)responseMsg.getData();
            RuleResultDeductionDTO ruleResultDeductionDTO = (RuleResultDeductionDTO)JSON.parseObject((String)JSON.toJSONString((Object)ruleResultDTO.getData()), RuleResultDeductionDTO.class);
            if (ruleResultDeductionDTO != null) {
                statementBO.setStatementAmount(ruleResultDeductionDTO.getStatementAmount());
                statementBO.setDeductionAmount(ruleResultDeductionDTO.getDeductionAmount());
            }
            return this.statementRepository.insertStatement(statementBO);
        }
        catch (Exception e) {
            log.error("deduction handle rule execute exception,ruleExecuteParam is{},responseMsg is {}", new Object[]{JSONObject.toJSONString((Object)ruleExecuteParam), JSONObject.toJSONString(responseMsg), e});
            return null;
        }
    }

    public Long deletedStatement(Long id) {
        return this.statementRepository.deletedStatement(id);
    }

    public Long updateStatement(StatementParam statementParam) {
        StatementBO statementBO = this.statementConvertor.paramToBO(statementParam);
        return this.statementRepository.updateStatement(statementBO);
    }

    public StatementDTO detailStatement(Long id) {
        StatementDTO statementDTO = this.statementRepository.detailStatement(id);
        Long contractId = statementDTO.getContractId();
        ResponseMsg<ContractInfoDTO> responseMsg = new ResponseMsg<ContractInfoDTO>();
        try {
            responseMsg = this.contractProxy.getContractDetail(contractId);
            ContractInfoDTO contractInfoDTO = (ContractInfoDTO)responseMsg.getData();
            statementDTO.setContractName(contractInfoDTO.getContractName());
            statementDTO.setContractAmount(contractInfoDTO.getContractAmount());
            statementDTO.setSupplierName(contractInfoDTO.getSupplierName());
            return statementDTO;
        }
        catch (Exception e) {
            log.error("query contract detail error,contractId is {}", (Object)contractId);
            return statementDTO;
        }
    }

    public PageInfo<StatementDTO> pageStatement(StatementQuery query) {
        return this.statementRepository.pageStatement(query);
    }

    public TotalAmountDTO totalAmount(StatementQuery query) {
        List<StatementDTO> statementDTOS = this.statementRepository.listStatement(query);
        if (statementDTOS == null) {
            ExceptionHandler.publish((String)"NROS-SBC-STATEMENT-0001");
        }
        BigDecimal totalStatementAmount = new BigDecimal(0);
        BigDecimal totalDeductionAmount = new BigDecimal(0);
        for (StatementDTO statementDTO : statementDTOS) {
            totalStatementAmount = totalStatementAmount.add(Objects.isNull(statementDTO.getStatementAmount()) ? new BigDecimal(0) : statementDTO.getStatementAmount());
            totalDeductionAmount = totalDeductionAmount.add(Objects.isNull(statementDTO.getTotalDeductionAmount()) ? new BigDecimal(0) : statementDTO.getTotalDeductionAmount());
        }
        return new TotalAmountDTO(totalStatementAmount, totalDeductionAmount);
    }

    public Long statementTimes(StatementQuery query) {
        List<StatementDTO> statementDTOS = this.statementRepository.listStatement(query);
        if (statementDTOS == null) {
            ExceptionHandler.publish((String)"NROS-SBC-STATEMENT-0001");
        }
        int statementTimes = statementDTOS.size();
        return statementTimes;
    }

    private RuleResultDTO foo(StatementBO statementBO) {
        ResponseMsg<RuleResultDTO> responseMsg = new ResponseMsg<RuleResultDTO>();
        RuleExecuteParam ruleExecuteParam = new RuleExecuteParam();
        JSONObject ruleParam = new JSONObject();
        ruleExecuteParam.setCompanyCode(statementBO.getCompanyCode());
        ruleExecuteParam.setCode("abd37a260a64497d9281da5281a4c507");
        ruleParam.put("contractAmount", (Object)statementBO.getContractAmount());
        StatementQuery query = new StatementQuery();
        query.setContractId(statementBO.getContractId());
        List<StatementDTO> statementDTOS = this.statementRepository.listStatement(query);
        if (statementDTOS == null) {
            ExceptionHandler.publish((String)"NROS-SBC-STATEMENT-0001");
        }
        BigDecimal totalStatementAmount = new BigDecimal(0);
        for (StatementDTO statementDTO : statementDTOS) {
            totalStatementAmount = totalStatementAmount.add(statementDTO.getStatementAmount());
        }
        BigDecimal thisTotalStatementAmount = totalStatementAmount.add(statementBO.getStatementAmount());
        ruleParam.put("totalStatementAmount", (Object)thisTotalStatementAmount);
        ruleExecuteParam.setParams(ruleParam);
        try {
            responseMsg = this.ruleProxy.ruleExecute(ruleExecuteParam);
            return (RuleResultDTO)responseMsg.getData();
        }
        catch (Exception e) {
            log.error("check totalAmount rule execute exception,ruleExecuteParam is{},responseMsg is {}", new Object[]{JSONObject.toJSONString((Object)ruleExecuteParam), JSONObject.toJSONString(responseMsg), e});
            return null;
        }
    }
}

