/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.sbc.card.client.model.enums;

import java.util.Arrays;
import java.util.Optional;

public enum PaymentCodeEnum {
    CASH("1101", "\u73b0\u91d1", "cash", "11"),
    BANK_UNION_GROCERY("1201", "\u94f6\u8054\u4e00\u4f53\u5316-\u767e\u8d27", "bankUnionGrocery", "12"),
    BANK_SHOP_GROCERY("1202", "\u94f6\u8054\u4e00\u4f53\u5316-\u8d85\u5e02", "bankShopGrocery", "12"),
    BANK_UNION_BANK_CARD("1205", "\u94f6\u8054\u4e00\u4f53\u5316-\u94f6\u884c\u5361", "bankUnionBankCard", "12"),
    BANK_UNION_WECHAT("1206", "\u94f6\u8054\u94f6\u884c\u5361-\u5fae\u4fe1", "bankWeChat", "12"),
    BANK_UNION_PAYMENT("1207", "\u94f6\u8054\u94f6\u884c\u5361-\u652f\u4ed8\u5b9d", "bankPayment", "12"),
    BANK_CODE_PAYMENT("1208", "\u94f6\u8054\u94f6\u884c\u5361-\u4e8c\u7ef4\u7801", "bankCodePayment", "12"),
    BANK_UNION_GROCERY_OFFLINE("1209", "\u94f6\u8054\u4e00\u4f53\u5316-\u767e\u8d27\uff08\u79bb\u7ebf\uff09", "bankUnionGroceryOffline", "12"),
    BANK_UNION_PAYMENT_CODE("1210", "\u94f6\u8054\u4e00\u4f53\u5316-\u4e8c\u7ef4\u7801", "bankUnionPaymentCode", "12"),
    BANK_UNION_WECHAT_OFFLINE("1211", "\u94f6\u8054\u94f6\u884c\u5361-\u5fae\u4fe1\uff08\u79bb\u7ebf\uff09", "bankWeChatOffline", "12"),
    BANK_UNION_PAYMENT_OFFLINE("1212", "\u94f6\u8054\u94f6\u884c\u5361-\u652f\u4ed8\u5b9d\uff08\u79bb\u7ebf\uff09", "bankPaymentOffline", "12"),
    TEMP_DEP("1804", "\u6682\u5b58\u6b3e", "tempDep", "18"),
    CHEQUE("1601", "\u652f\u7968", "cheque", "16"),
    CABLE("1602", "\u7535\u6c47", "cable", "16"),
    CENTER_BANK("1702", "\u4e2d\u884c\u6536\u5355\u884c", "centerBank", "20"),
    ICBC_BANK("1701", "\u5de5\u884c\u884c\u6536\u5355\u884c", "icbcBank", "19"),
    IN_USE("1805", "\u5185\u90e8\u9886\u7528", "inUse", "18");

    private String paymentCode;
    private String paymentName;
    private String code;
    private String typeId;

    private PaymentCodeEnum(String paymentCode, String paymentName, String code, String typeId) {
        this.paymentCode = paymentCode;
        this.paymentName = paymentName;
        this.code = code;
        this.typeId = typeId;
    }

    public static Optional<PaymentCodeEnum> of(String paymentCode) {
        return Arrays.stream(PaymentCodeEnum.values()).filter(code -> code.getPaymentCode().equals(paymentCode)).findFirst();
    }

    public String getPaymentCode() {
        return this.paymentCode;
    }

    public String getPaymentName() {
        return this.paymentName;
    }

    public String getCode() {
        return this.code;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public static String getCodeByPaymentCode(String paymentCode) {
        String code = null;
        for (PaymentCodeEnum paymentCodeEnum : PaymentCodeEnum.values()) {
            if (!paymentCodeEnum.getPaymentCode().equals(paymentCode)) continue;
            code = paymentCodeEnum.getCode();
        }
        return code;
    }
}

