/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.common.model.param;

import com.google.gson.annotations.SerializedName;

public class PageParam {
    @SerializedName(value="pageIndex", alternate={"pageNo", "pageNow"})
    protected int pageIndex;
    protected int pageSize = 20;
    protected int start;
    protected int end;
    protected long total;
    protected long pages;

    public PageParam() {
    }

    public PageParam(int pageIndex, int pageSize) {
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
        this.start = (this.pageIndex - 1) * this.pageSize;
        this.end = this.start + this.pageSize;
    }

    public PageParam(int pageIndex, int pageSize, long total) {
        this(pageIndex, pageSize);
        this.total = total;
        this.pages = this.total / (long)this.pageSize;
        if (this.total % (long)this.pageSize != 0L) {
            ++this.pages;
        }
    }

    public PageParam(int pageIndex, int pageSize, long total, int start, int end, long pages) {
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
        this.total = total;
        this.pages = pages;
        this.start = start;
        this.end = end;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public long getTotal() {
        return this.total;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public long getPages() {
        return this.pages;
    }

    public void setTotal(int total) {
        this.total = total;
        this.pages = this.total / (long)this.pageSize;
        if (this.total % (long)this.pageSize != 0L) {
            ++this.pages;
        }
    }
}

