/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.zmq.producer;

import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.ztesoft.zsmart.nros.base.exception.BusiException;
import com.ztesoft.zsmart.nros.base.zmq.config.ZMQConfig;
import com.ztesoft.zsmart.nros.base.zmq.entity.NrosMQMessage;
import java.util.Properties;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultZMQProducer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ZMQConfig zmqCfg;
    private static Producer producer;

    public Producer getProducer() {
        if (null == producer) {
            producer = this.buildProducer();
        }
        return producer;
    }

    @PreDestroy
    private void shutdown() {
        try {
            if (producer != null && producer.isStarted()) {
                producer.shutdown();
                this.logger.error("MQ Msg producer shutdown successfully");
            }
        }
        catch (ONSClientException e) {
            this.logger.error("MQ Msg producer shutdown error-->", (Throwable)e);
        }
    }

    private Producer buildProducer() {
        if (this.zmqCfg.isEnabled()) {
            Properties properties = new Properties();
            properties.setProperty("AccessKey", this.zmqCfg.getAccessKey());
            properties.setProperty("SecretKey", this.zmqCfg.getSecretKey());
            properties.setProperty("SendMsgTimeoutMillis", this.zmqCfg.getProducerSendTimeout());
            properties.setProperty("NAMESRV_ADDR", this.zmqCfg.getGlobalNamesrvAddr());
            try {
                this.logger.info(" ############## Begin to create ZMQ Producer id@");
                Producer producer = ONSFactory.createProducer((Properties)properties);
                producer.start();
                this.logger.info(" ############## ZMQ Producer created success.");
                return producer;
            }
            catch (ONSClientException e) {
                this.logger.error("MQ Msg producer created error-->", (Throwable)e);
                throw new BusiException("500", "MQ Msg producer created error @" + DefaultZMQProducer.class);
            }
        }
        return null;
    }

    public SendResult sendMessage(Producer producer, NrosMQMessage msg) throws ONSClientException {
        try {
            SendResult result = producer.send(msg.getMqMessage());
            if (result != null) {
                this.logger.info("Send mq message success! Topic is:" + msg.getMqMessage().getTopic());
            } else {
                this.logger.warn("sendResult is null.........");
            }
            return result;
        }
        catch (ONSClientException e) {
            this.logger.error("Thread.sleep 1 s___error is " + e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

