/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.zmq.producer;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionChecker;
import com.aliyun.openservices.ons.api.transaction.TransactionStatus;
import com.ztesoft.zsmart.nros.base.exception.BusiException;
import com.ztesoft.zsmart.nros.base.session.SessionUtils;
import com.ztesoft.zsmart.nros.base.zmq.entity.NrosMQMessage;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractZMQCheckHandler
implements LocalTransactionChecker {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public TransactionStatus check(Message msg) {
        String msgId = msg.getMsgID();
        this.logger.info("#########ZMQHandler Check msg-->" + msg.getTopic() + " " + msg.getTag() + " " + new String(msg.getBody(), Charset.forName("UTF-8")));
        NrosMQMessage nrosMsg = null;
        try {
            nrosMsg = NrosMQMessage.convertFromMQMessage(msg);
            if (null != nrosMsg.getUserId()) {
                this.logger.info("#########ZMQHandler Check msg hasValidSessionByUserId ->." + SessionUtils.hasValidSessionByUserId(nrosMsg.getUserId() + ""));
            }
            TransactionStatus transactionStatus = TransactionStatus.Unknow;
            boolean isCommit = this.checkBusinesses(nrosMsg);
            transactionStatus = isCommit ? TransactionStatus.CommitTransaction : TransactionStatus.RollbackTransaction;
            this.logger.info("Send mq message success! Topic is:" + nrosMsg.getMqMessage().getTopic());
            this.logger.warn("Message Id:{}transactionStatus:{}", (Object)msgId, (Object)transactionStatus.name());
            return transactionStatus;
        }
        catch (BusiException e) {
            this.logger.error(e.toString());
            return TransactionStatus.RollbackTransaction;
        }
        catch (Exception e) {
            this.logger.error("Message Id:{}", (Object)msgId, (Object)e);
            return TransactionStatus.RollbackTransaction;
        }
    }

    public abstract boolean execbusinessService(NrosMQMessage var1, Object var2);

    public abstract boolean checkBusinesses(NrosMQMessage var1);
}

