/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.zmq.consumer;

import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.ztesoft.zsmart.nros.base.exception.BusiException;
import com.ztesoft.zsmart.nros.base.zmq.config.ConsumerConfig;
import com.ztesoft.zsmart.nros.base.zmq.config.ZMQConfig;
import com.ztesoft.zsmart.nros.base.zmq.consumer.AbstractZMQHandler;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultTZMQConsumer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ZMQConfig zmqCfg;

    @PostConstruct
    public void init() throws BusiException {
        if (this.zmqCfg.isTconsumerEnabled()) {
            Properties properties = new Properties();
            properties.setProperty("GROUP_ID", this.zmqCfg.getTgroupId());
            properties.setProperty("AccessKey", this.zmqCfg.getAccessKey());
            properties.setProperty("SecretKey", this.zmqCfg.getSecretKey());
            properties.setProperty("SendMsgTimeoutMillis", this.zmqCfg.getProducerSendTimeout());
            properties.put("maxReconsumeTimes", this.zmqCfg.getReconsumeTimes());
            properties.setProperty("NAMESRV_ADDR", this.zmqCfg.getGlobalNamesrvAddr());
            Consumer consumer = ONSFactory.createConsumer((Properties)properties);
            for (ConsumerConfig consumerConfig : this.zmqCfg.getTconsumers()) {
                this.logger.info(" MQ Msg consumer topic@" + consumerConfig.getTopic());
                try {
                    AbstractZMQHandler abstractZMQHandler = (AbstractZMQHandler)Class.forName(consumerConfig.getHandlerClass()).newInstance();
                    consumer.subscribe(consumerConfig.getTopic(), "*", (MessageListener)abstractZMQHandler);
                    this.logger.info(" MQ Msg consumer handlerClass@" + consumerConfig.getHandlerClass());
                }
                catch (Exception e) {
                    this.logger.error("MQ Msg consumer topic@" + consumerConfig.getTopic() + " handler error-->", (Throwable)e);
                    throw new BusiException("500", "MQ Msg consumer id@" + this.zmqCfg.getGroupId() + " handler error @" + DefaultTZMQConsumer.class);
                }
            }
            try {
                consumer.start();
                this.logger.info(" ############## ZMQ consumer created success.");
            }
            catch (ONSClientException e) {
                this.logger.error("MQ Msg consumer id@" + this.zmqCfg.getGroupId() + " created error-->", (Throwable)e);
                throw new BusiException("500", "MQ Msg consumer id@" + this.zmqCfg.getGroupId() + " created error @" + DefaultTZMQConsumer.class);
            }
            this.logger.info("rocketMq Client start success");
        }
    }
}

