/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.util;

import java.text.MessageFormat;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtil {
    public static final String MAIL_REG_EXPRESS = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
    public static final String TEL_REG_EXPRESS = "^\\d+$";
    public static final char[] ch = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1'};

    private StringUtil() {
    }

    public static boolean isNull(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static boolean isNotNull(String value) {
        return !StringUtil.isNull(value);
    }

    public static boolean isNumeric(String value) {
        return StringUtil.isNotNull(value) && value.matches("\\d*");
    }

    public static String leftFill(String value, int offset, String fillChar) {
        if (value != null && offset > 0) {
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < offset; ++i) {
                buff.append(fillChar);
            }
            buff.append(value);
            return buff.toString();
        }
        return value;
    }

    public static Long parseLong(String value) {
        Long longValue = null;
        if (StringUtil.isNotNull(value)) {
            try {
                longValue = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return longValue;
    }

    public static Integer parseInteger(String value) {
        Integer intValue = null;
        if (StringUtil.isNotNull(value)) {
            try {
                intValue = Integer.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return intValue;
    }

    public static Double parseDouble(String value) {
        Double doubleValue = null;
        if (StringUtil.isNotNull(value)) {
            try {
                doubleValue = Double.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return doubleValue;
    }

    public static Float parseFloat(String value) {
        Float floatValue = null;
        if (StringUtil.isNotNull(value)) {
            try {
                floatValue = Float.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return floatValue;
    }

    public static Boolean parseBoolean(String value) {
        return Boolean.valueOf(value);
    }

    public static String getRangeString(String sourceString, int startPos, int endPos) {
        if (StringUtil.isNotNull(sourceString) && startPos >= 0 && endPos >= 0 && endPos > startPos && endPos <= sourceString.length()) {
            return sourceString.substring(startPos, endPos);
        }
        return null;
    }

    public static String getRangeString(String sourceString, String startString, String endString) {
        if (StringUtil.isNotNull(startString) && StringUtil.isNotNull(endString)) {
            String _sourceString = sourceString.toUpperCase();
            String _startString = startString.toUpperCase();
            String _endString = endString.toUpperCase();
            int startPos = _sourceString.indexOf(_startString);
            int endPos = _sourceString.indexOf(_endString);
            return StringUtil.getRangeString(sourceString, startPos += _startString.length(), endPos);
        }
        return null;
    }

    public static String getRandomString(int length) {
        Random random = new Random();
        if (length > 0) {
            int i;
            int index = 0;
            char[] temp = new char[length];
            int num = random.nextInt();
            for (i = 0; i < length % 5; ++i) {
                temp[index++] = ch[num & 0x3F];
                num >>= 6;
            }
            for (i = 0; i < length / 5; ++i) {
                num = random.nextInt();
                for (int j = 0; j < 5; ++j) {
                    temp[index++] = ch[num & 0x3F];
                    num >>= 6;
                }
            }
            return new String(temp, 0, length);
        }
        return "";
    }

    public static boolean isEmail(String email) {
        Pattern regex = Pattern.compile(MAIL_REG_EXPRESS);
        Matcher matcher = regex.matcher(email);
        return matcher.matches();
    }

    public static boolean isTel(String tel) {
        Pattern regex = Pattern.compile(TEL_REG_EXPRESS);
        Matcher matcher = regex.matcher(tel);
        return matcher.matches();
    }

    public static String byte2hex(byte[] b) {
        char[] digital = "0123456789ABCDEF".toCharArray();
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < b.length; ++i) {
            int bit = (b[i] & 0xF0) >> 4;
            sb.append(digital[bit]);
            bit = b[i] & 0xF;
            sb.append(digital[bit]);
        }
        return sb.toString();
    }

    public static byte[] hex2byte(String hex) {
        String digital = "0123456789ABCDEF";
        char[] hex2char = hex.toCharArray();
        byte[] bytes = new byte[hex.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            int temp = digital.indexOf(hex2char[2 * i]) * 16;
            bytes[i] = (byte)((temp += digital.indexOf(hex2char[2 * i + 1])) & 0xFF);
        }
        return bytes;
    }

    public static String bin2hex(String str) {
        byte[] bs = str.getBytes();
        return StringUtil.byte2hex(bs);
    }

    public static String hex2bin(String hex) {
        return new String(StringUtil.hex2byte(hex));
    }

    public static String formart(String template, Object ... values) {
        return MessageFormat.format(template, values);
    }

    public static String analysisURL(String url, String[] paras, char[] target) throws RuntimeException {
        if (target.length != 2) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int urlLength = url.length();
        int left_pos = -1;
        int rigth_pos = -1;
        int pIdx = 0;
        for (int i = 0; i < urlLength; ++i) {
            char temp = url.charAt(i);
            if (temp == target[0]) {
                if (left_pos > 0) {
                    throw new RuntimeException("URL: [" + url + "] format ERROR: '" + target[0] + "' continuous happens more than once.");
                }
                left_pos = i;
                continue;
            }
            if (temp == target[1]) {
                if (left_pos < 0) {
                    throw new RuntimeException("URL: [" + url + "] format ERROR: '" + target[0] + "' is missed.");
                }
                rigth_pos = i;
                if (pIdx >= paras.length) {
                    throw new RuntimeException("URL: [" + url + "] ERROR: The number of input paras is less.");
                }
                sb.append(paras[pIdx++]);
                rigth_pos = -1;
                left_pos = -1;
                continue;
            }
            if (left_pos >= 0 || rigth_pos >= 0) continue;
            sb.append(temp);
        }
        if (left_pos > -1 && rigth_pos < 0) {
            throw new RuntimeException("URL: [" + url + "] format ERROR: '" + target[1] + "' is missed.");
        }
        return sb.toString();
    }

    public static String analysisURL(String url, String[] paras) {
        char[] sep = new char[]{'{', '}'};
        return StringUtil.analysisURL(url, paras, sep);
    }
}

