/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectUtil {
    private static final Logger log = LoggerFactory.getLogger(ReflectUtil.class);

    public static Object getFieldValue(Object obj, String fieldName) {
        Object result = null;
        Field field = ReflectUtil.getField(obj, fieldName);
        if (field != null) {
            field.setAccessible(true);
            try {
                result = field.get(obj);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return result;
    }

    private static Field getField(Object obj, String fieldName) {
        Field field = null;
        for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();
            try {
                field = clazz.getDeclaredField(fieldName);
                break;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return field;
    }

    public static void setFieldValue(Object obj, String fieldName, String fieldValue) {
        Field field = ReflectUtil.getField(obj, fieldName);
        if (field != null) {
            try {
                field.setAccessible(true);
                field.set(obj, fieldValue);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static Object reflectByPath(String path) {
        try {
            String className = path.substring(0, path.lastIndexOf("."));
            String methodName = path.substring(path.lastIndexOf(".") + 1, path.length());
            Class<?> c = Class.forName(className);
            Constructor<?> con = c.getConstructor(new Class[0]);
            Object obj = con.newInstance(new Object[0]);
            Method method = c.getMethod(methodName, new Class[0]);
            return method.invoke(obj, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

