/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.interceptor;

import com.ztesoft.zsmart.nros.base.annotation.DatapriveAop;
import com.ztesoft.zsmart.nros.base.util.DataPrivilegeUtils;
import com.ztesoft.zsmart.nros.base.util.ReflectUtil;
import java.sql.Connection;
import java.util.Properties;
import org.apache.ibatis.executor.statement.RoutingStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class DataPrivilegeInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(DataPrivilegeInterceptor.class);

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    public Object intercept(Invocation invocation) throws Throwable {
        log.debug("\u8fdb\u5165 DataPrivilegeInterceptor \u62e6\u622a\u5668...");
        if (invocation.getTarget() instanceof RoutingStatementHandler) {
            RoutingStatementHandler handler = (RoutingStatementHandler)invocation.getTarget();
            StatementHandler delegate = (StatementHandler)ReflectUtil.getFieldValue(handler, "delegate");
            MappedStatement mappedStatement = (MappedStatement)ReflectUtil.getFieldValue(delegate, "mappedStatement");
            DatapriveAop datapriveAop = DataPrivilegeUtils.getDataPrivilegeByDelegate(mappedStatement);
            if (datapriveAop == null) {
                log.debug("\u4e0d\u5904\u7406\u6570\u636e\u6743\u9650...");
                return invocation.proceed();
            }
            log.debug("\u6570\u636e\u6743\u9650\u5904\u7406[\u62fc\u63a5SQL]...");
            BoundSql boundSql = delegate.getBoundSql();
            ReflectUtil.setFieldValue(boundSql, "sql", this.warpDataPrivilegeSql(boundSql.getSql()));
        }
        return invocation.proceed();
    }

    protected String warpDataPrivilegeSql(String sql) {
        return sql;
    }
}

