/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.i18n;

import com.ztesoft.zsmart.nros.base.util.SpringContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ResourceBundleMessageSource;

public class I18nUtils {
    private static final Logger logger = LoggerFactory.getLogger(I18nUtils.class);

    public static String getMessage(String errorCode) {
        String localeMessage = "";
        try {
            localeMessage = I18nUtils.getMessage(errorCode, null);
        }
        catch (Exception var3) {
            logger.error("No code named " + errorCode + " found in I18n file");
        }
        return localeMessage;
    }

    public static String getMessage(String errorCode, Object[] args) {
        String localeMessage = "";
        try {
            MessageSource messageSource = (MessageSource)SpringContextUtils.getBean(ResourceBundleMessageSource.class);
            localeMessage = messageSource.getMessage(errorCode, args, LocaleContextHolder.getLocale());
        }
        catch (Exception var4) {
            logger.error("No code named " + errorCode + " found in I18n file");
        }
        return localeMessage;
    }
}

