/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.config;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.ztesoft.zsmart.nros.base.util.StringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@ConfigurationProperties(prefix="swagger")
@EnableSwagger2
@ConditionalOnProperty(value={"swagger.enabled"}, havingValue="true")
public class SwaggerConfig {
    private String basePackage;
    private String excludePackage;
    private String docTitle;
    private String docDescription;
    private String docVersion;
    private static final String SEPARATOR = ",";

    @Bean
    public Docket createRestApi() {
        HashSet<String> produces = new HashSet<String>();
        produces.add("application/json");
        ParameterBuilder app_id = new ParameterBuilder();
        ParameterBuilder signature = new ParameterBuilder();
        ParameterBuilder timestamp = new ParameterBuilder();
        ArrayList<Parameter> pars = new ArrayList<Parameter>();
        app_id.name("appId").description("appId").modelRef((ModelReference)new ModelRef("string")).parameterType("header").required(false).defaultValue("cs-usUfK7dCi0DFesov").build();
        signature.name("signature").description("").modelRef((ModelReference)new ModelRef("string")).parameterType("header").required(false).defaultValue("c9243954de9e925ca8a209041eb68605b486694f").build();
        timestamp.name("timestamp").description("").modelRef((ModelReference)new ModelRef("string")).parameterType("header").required(false).defaultValue("1551765698270").build();
        pars.add(app_id.build());
        pars.add(signature.build());
        pars.add(timestamp.build());
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).produces(produces).useDefaultResponseMessages(true).select().apis(this.basePackage(this.getExcludePackage(), this.getBasePackage())).paths(PathSelectors.any()).build().globalOperationParameters(pars);
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.getDocTitle()).description(this.getDocDescription()).version(this.getDocVersion()).build();
    }

    public Predicate<RequestHandler> basePackage(String exceludePackages, String basePackages) {
        return input -> (Boolean)SwaggerConfig.declaringClass(input).transform(this.handlerPackage(exceludePackages, basePackages)).or((Object)true);
    }

    private Function<Class<?>, Boolean> handlerPackage(String exceludePackages, String basePackages) {
        return input -> {
            boolean isMatch;
            if (StringUtil.isNotNull(exceludePackages)) {
                for (String strPackage : exceludePackages.split(SEPARATOR)) {
                    isMatch = input.getPackage().getName().startsWith(strPackage);
                    if (!isMatch) continue;
                    return false;
                }
            }
            for (String strPackage : basePackages.split(SEPARATOR)) {
                isMatch = input.getPackage().getName().startsWith(strPackage);
                if (!isMatch) continue;
                return true;
            }
            return false;
        };
    }

    private static Optional<? extends Class<?>> declaringClass(RequestHandler input) {
        return Optional.fromNullable((Object)input.declaringClass());
    }

    public String getBasePackage() {
        this.basePackage = StringUtil.isNull(this.basePackage) ? "" : this.basePackage.trim();
        return this.basePackage;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public String getExcludePackage() {
        this.excludePackage = StringUtil.isNull(this.excludePackage) ? "" : this.excludePackage.trim();
        return this.excludePackage;
    }

    public void setExcludePackage(String excludePackage) {
        this.excludePackage = excludePackage;
    }

    public String getDocTitle() {
        return this.docTitle;
    }

    public void setDocTitle(String docTitle) {
        this.docTitle = docTitle;
    }

    public String getDocDescription() {
        return this.docDescription;
    }

    public void setDocDescription(String docDescription) {
        this.docDescription = docDescription;
    }

    public String getDocVersion() {
        return this.docVersion;
    }

    public void setDocVersion(String docVersion) {
        this.docVersion = docVersion;
    }
}

