/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.config;

import com.alibaba.druid.pool.DruidDataSource;
import java.io.IOException;
import javax.sql.DataSource;
import org.apache.ibatis.session.AutoMappingBehavior;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Configuration
@MapperScan(basePackages={"com.ztesoft.zsmart.nros.**.plugin.**.mapper"}, sqlSessionFactoryRef="jdeSqlSession")
@ConditionalOnProperty(value={"spring.datasource.jde.enabled"}, havingValue="true")
public class MySlaveBatisConfig {
    @Value(value="${mybatis.jde.mapper-locations}")
    private String mapperLocation;

    @ConfigurationProperties(prefix="spring.datasource.jde")
    @Bean(name={"jdeDataSource"})
    public DataSource jdeDataSource() {
        return new DruidDataSource();
    }

    @Bean(name={"jdeTransactionManager"})
    public DataSourceTransactionManager jdeTransactionManager(@Qualifier(value="jdeDataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean(name={"jdeTransactionTemplate"})
    public TransactionTemplate jdeTransactionTemplate(@Qualifier(value="jdeTransactionManager") DataSourceTransactionManager transactionTemplate) {
        return new TransactionTemplate((PlatformTransactionManager)transactionTemplate);
    }

    @Bean(name={"jdeSqlSession"})
    public SqlSessionFactoryBean jdeSqlSession(@Qualifier(value="jdeDataSource") DataSource dataSource) throws IOException {
        SqlSessionFactoryBean sqlSessionFactoryBean = new SqlSessionFactoryBean();
        sqlSessionFactoryBean.setDataSource(dataSource);
        org.apache.ibatis.session.Configuration configuration = this.getConfiguration();
        sqlSessionFactoryBean.setConfiguration(configuration);
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        sqlSessionFactoryBean.setMapperLocations(resolver.getResources(this.mapperLocation));
        return sqlSessionFactoryBean;
    }

    @Bean(name={"jdeSqlSessionTemplate"})
    public SqlSessionTemplate jdeSqlSessionTemplate(@Qualifier(value="jdeSqlSession") SqlSessionFactoryBean sqlSessionFactoryBean) throws Exception {
        SqlSessionTemplate sqlSessionTemplate = new SqlSessionTemplate(sqlSessionFactoryBean.getObject());
        return sqlSessionTemplate;
    }

    private org.apache.ibatis.session.Configuration getConfiguration() {
        org.apache.ibatis.session.Configuration configuration = new org.apache.ibatis.session.Configuration();
        configuration.setMapUnderscoreToCamelCase(true);
        configuration.setAutoMappingBehavior(AutoMappingBehavior.FULL);
        return configuration;
    }
}

