/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.aspect;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ztesoft.zsmart.nros.base.exception.BusiException;
import com.ztesoft.zsmart.nros.base.exception.SessionException;
import com.ztesoft.zsmart.nros.base.session.SessionUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@Aspect
@Order(value=1)
public class SessionAspect {
    @Value(value="${spring.profiles.active:local}")
    private String profilesActive;
    private Logger logger = LoggerFactory.getLogger(SessionAspect.class);
    private Logger auditLogger = LoggerFactory.getLogger((String)"auditLogger");

    @Pointcut(value="@within(com.ztesoft.zsmart.nros.base.annotation.SessionController)")
    public void pointCut() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint pjp) {
        Object result = null;
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String uri = "";
        if (request.getRequestURI() != null) {
            uri = request.getRequestURI();
        }
        String sessionId = request.getRequestedSessionId();
        this.logger.info("sessionId->." + sessionId);
        if (!"LOCAL".equalsIgnoreCase(this.profilesActive) && !"DEV".equalsIgnoreCase(this.profilesActive)) {
            if (StringUtils.isEmpty((String)sessionId)) throw new SessionException("\u672a\u6388\u6743\uff0c\u8bf7\u767b\u5f55\uff01");
            if (!SessionUtils.hasValidSessionBySessionId(sessionId)) {
                throw new SessionException("\u767b\u5f55\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\uff01");
            }
        } else {
            SessionUtils.hasValidSessionBySessionId(sessionId);
        }
        SessionUtils.updateSessionLastAccessTime(sessionId);
        this.logBeforeProceed(pjp, request, uri);
        long beforeMs = System.currentTimeMillis();
        try {
            result = pjp.proceed(pjp.getArgs());
        }
        catch (BusiException | ConstraintViolationException exception) {
            SessionUtils.removeLocalSession();
            long afterMs = System.currentTimeMillis();
            this.logger.info("{} {} {} {}", new Object[]{request.getMethod(), uri, afterMs - beforeMs, HttpStatus.NOT_ACCEPTABLE.value()});
            throw exception;
        }
        catch (Throwable throwable) {
            SessionUtils.removeLocalSession();
            long afterMs = System.currentTimeMillis();
            this.logger.info("{} {} {} {}", new Object[]{request.getMethod(), uri, afterMs - beforeMs, HttpStatus.INTERNAL_SERVER_ERROR.value()});
            throw new RuntimeException(throwable.getMessage(), throwable);
        }
        SessionUtils.removeLocalSession();
        long afterMs = System.currentTimeMillis();
        this.logger.info("{} {} {} {}", new Object[]{request.getMethod(), uri, afterMs - beforeMs, HttpStatus.OK.value()});
        this.logger.info("response: {}", (Object)this.getResponseString(result));
        return result;
    }

    private void logBeforeProceed(ProceedingJoinPoint pjp, HttpServletRequest request, String uri) {
        try {
            String remoteIp = request.getRemoteAddr();
            Long userId = 0L;
            if (!"LOCAL".equalsIgnoreCase(this.profilesActive) && !"DEV".equalsIgnoreCase(this.profilesActive)) {
                userId = SessionUtils.getSessionInfo().getUserId();
            }
            JSONObject requestLog = new JSONObject();
            requestLog.put("userId", (Object)userId);
            requestLog.put("requestTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            requestLog.put("remoteIp", (Object)remoteIp);
            requestLog.put("methodType", (Object)request.getMethod());
            requestLog.put("requestUri", (Object)uri);
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)request.getMethod(), (CharSequence)RequestMethod.GET.toString())) {
                String parameterMapStr = this.getRequestParametersString(request);
                requestLog.put("requestParams", (Object)parameterMapStr);
            } else {
                ArrayList<Object> parms = new ArrayList<Object>();
                for (int i = 0; i < pjp.getArgs().length; ++i) {
                    if (pjp.getArgs()[i] instanceof BindingResult) continue;
                    parms.add(pjp.getArgs()[i]);
                }
                requestLog.put("requestParams", (Object)JSON.toJSONString(parms));
            }
            this.auditLogger.info("SessionAspect:{}", (Object)requestLog.toJSONString());
        }
        catch (Exception e) {
            this.logger.error("\u65e5\u5fd7\u6253\u5370\u9519\u8bef\uff01");
        }
    }

    private String getRequestParametersString(HttpServletRequest request) {
        String reqParam = "null";
        reqParam = JSON.toJSONString((Object)request.getParameterMap());
        return reqParam;
    }

    private String getResponseString(Object retVal) {
        if (null == retVal) {
            return "null";
        }
        return JSON.toJSONString((Object)retVal);
    }
}

