/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.aspect;

import com.ztesoft.zsmart.nros.base.annotation.RateLimiterAop;
import com.ztesoft.zsmart.nros.base.exception.ExceptionHandler;
import com.ztesoft.zsmart.nros.base.util.RedisLimitUtils;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RedisRateLimiterAspect {
    private static final Logger log = LoggerFactory.getLogger(RedisRateLimiterAspect.class);
    private ExpressionParser parser = new SpelExpressionParser();
    @Autowired
    private RedisLimitUtils redisLimitUtils;

    @Pointcut(value="@annotation(com.ztesoft.zsmart.nros.base.annotation.RateLimiterAop)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        String className = point.getTarget().getClass().getName();
        Object[] args = point.getArgs();
        String[] paramNames = signature.getParameterNames();
        StandardEvaluationContext context = new StandardEvaluationContext();
        for (int i = 0; i < args.length; ++i) {
            context.setVariable(paramNames[i], args[i]);
        }
        RateLimiterAop limiterAop = method.getAnnotation(RateLimiterAop.class);
        TimeUnit timeUnit = limiterAop.timeUnit();
        long capacity = limiterAop.capacity();
        long intervalTime = timeUnit.toMillis(limiterAop.intervalTime());
        String errorCode = limiterAop.value();
        String key = StringUtils.isEmpty((CharSequence)limiterAop.key()) ? method.getName() : (String)this.parser.parseExpression(limiterAop.key()).getValue((EvaluationContext)context, String.class);
        String limiterAopName = StringUtils.isEmpty((CharSequence)limiterAop.scopeName()) ? className : limiterAop.scopeName();
        String redisKey = limiterAopName + "#" + key;
        if (this.redisLimitUtils.limitHandler(redisKey, capacity, intervalTime, intervalTime * capacity * 5L)) {
            log.info("\u83b7\u53d6\u4ee4\u724c\u6210\u529f!class={},method={},key={}", new Object[]{className, method, redisKey});
            return point.proceed();
        }
        log.info("\u83b7\u53d6\u4ee4\u724c\u5931\u8d25,class={},method={},key={}", new Object[]{className, method, redisKey});
        ExceptionHandler.publish(errorCode);
        return null;
    }
}

