/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.aspect;

import com.alibaba.fastjson.JSON;
import com.ztesoft.zsmart.nros.base.annotation.LogMonitorAop;
import com.ztesoft.zsmart.nros.base.exception.BusiException;
import com.ztesoft.zsmart.nros.base.exception.ExceptionHandler;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Aspect
@Order(value=1)
public class LogMonitorAspect {
    private Logger logger = LoggerFactory.getLogger(LogMonitorAspect.class);

    @Pointcut(value="@annotation(com.ztesoft.zsmart.nros.base.annotation.LogMonitorAop)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint pjp) {
        try {
            String className = pjp.getTarget().getClass().getName();
            MethodSignature signature = (MethodSignature)pjp.getSignature();
            Method method = signature.getMethod();
            String methodName = signature.getName();
            Object[] args = pjp.getArgs();
            LogMonitorAop logMonitorAop = method.getAnnotation(LogMonitorAop.class);
            if (logMonitorAop.logArgs()) {
                this.logger.info("[{}]-[{}] {}#{}() => params:{} ", new Object[]{logMonitorAop.appId(), logMonitorAop.bizType(), className, methodName, JSON.toJSONString((Object)args)});
            }
            Object result = pjp.proceed(args);
            if (logMonitorAop.logResult()) {
                this.logger.info("[{}]-[{}] {}#{}() => result:{} ", new Object[]{logMonitorAop.appId(), logMonitorAop.bizType(), className, methodName, JSON.toJSONString((Object)result)});
            }
            return result;
        }
        catch (BusiException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            ExceptionHandler.publish("", "" + throwable.getMessage(), throwable);
            return null;
        }
    }
}

