/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.util.project.hxmkl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.ztesoft.zsmart.nros.base.model.HttpClientResult;
import com.ztesoft.zsmart.nros.base.util.project.hxmkl.SignUtil;
import java.util.HashMap;
import java.util.Map;

public class HttpClientUtils
extends com.ztesoft.zsmart.nros.base.util.HttpClientUtils {
    public static HttpClientResult doGetWithSign(String url, Map<String, String> params, String appId, String appSecret) throws Exception {
        Map<String, String> headers = HttpClientUtils.createSignHeaders(appId, appSecret);
        return HttpClientUtils.doGet(url, headers, params);
    }

    public static HttpClientResult doPostWithSign(String url, Map<String, String> params, String appId, String appSecret) throws Exception {
        Map<String, String> headers = HttpClientUtils.createSignHeaders(appId, appSecret);
        return HttpClientUtils.doPost(url, headers, params);
    }

    public static HttpClientResult doPostWithSign(String url, JSONObject params, String appId, String appSecret) throws Exception {
        Map<String, String> headers = HttpClientUtils.createSignHeaders(appId, appSecret);
        return HttpClientUtils.doPost(url, headers, params);
    }

    public static HttpClientResult doPostWithSign(String url, JSONArray params, String appId, String appSecret) throws Exception {
        Map<String, String> headers = HttpClientUtils.createSignHeaders(appId, appSecret);
        return HttpClientUtils.doPost(url, headers, params);
    }

    public static HttpClientResult doPutWithSign(String url, Map<String, String> params, String appId, String appSecret) throws Exception {
        Map<String, String> headers = HttpClientUtils.createSignHeaders(appId, appSecret);
        return HttpClientUtils.doPut(url, headers, params);
    }

    public static HttpClientResult doPutWithSign(String url, JSONObject params, String appId, String appSecret) throws Exception {
        Map<String, String> headers = HttpClientUtils.createSignHeaders(appId, appSecret);
        return HttpClientUtils.doPut(url, headers, params);
    }

    public static HttpClientResult doPutWithSign(String url, JSONArray params, String appId, String appSecret) throws Exception {
        Map<String, String> headers = HttpClientUtils.createSignHeaders(appId, appSecret);
        return HttpClientUtils.doPut(url, headers, params);
    }

    public static HttpClientResult doDeleteWithSign(String url, Map<String, String> params, String appId, String appSecret) throws Exception {
        Map<String, String> headers = HttpClientUtils.createSignHeaders(appId, appSecret);
        return HttpClientUtils.doDelete(url, headers, params);
    }

    public static HttpClientResult doDeleteWithSign(String url, JSONObject params, String appId, String appSecret) throws Exception {
        Map<String, String> headers = HttpClientUtils.createSignHeaders(appId, appSecret);
        return HttpClientUtils.doDelete(url, headers, params);
    }

    private static Map<String, String> createSignHeaders(String appId, String appSecret) {
        String nonceStr = SignUtil.createNonceStr();
        Long timestamp = SignUtil.createTimestamp();
        HashMap headers = Maps.newHashMap();
        headers.put("rs-api-id", appId);
        headers.put("rs-nonce", nonceStr);
        headers.put("rs-timestamp", timestamp.toString());
        headers.put("rs-sign", SignUtil.sign(appId, appSecret, nonceStr, timestamp));
        return headers;
    }

    public static HttpClientResult doPostWithSignPtcust(String url, JSONObject params, String appSecret) throws Exception {
        Map<String, String> headers = HttpClientUtils.createSignHeadersPtcust(appSecret);
        return HttpClientUtils.doPost(url, headers, params);
    }

    private static Map<String, String> createSignHeadersPtcust(String appSecret) throws Exception {
        String nonceStr = SignUtil.createNonceStr();
        Long timestamp = SignUtil.getTimestampMillis();
        String sign = SignUtil.signPtcust(appSecret, nonceStr, timestamp);
        HashMap headers = Maps.newHashMap();
        headers.put("redstar-nocestr", nonceStr);
        headers.put("redstar-timestamp", timestamp.toString());
        headers.put("redstar-sign", sign);
        return headers;
    }
}

