/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.interceptor;

import com.ztesoft.zsmart.nros.base.session.SessionUtils;
import com.ztesoft.zsmart.nros.base.util.RuntimeContext;
import com.ztesoft.zsmart.nros.base.util.StringUtil;
import com.ztesoft.zsmart.nros.common.session.SessionInfo;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FeignInterceptor
implements RequestInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(FeignInterceptor.class);

    public void apply(RequestTemplate requestTemplate) {
        SessionInfo sessionInfo = SessionUtils.getSessionInfo();
        String userId = RuntimeContext.getValue("user_id");
        String userName = RuntimeContext.getValue("user_name");
        try {
            if (sessionInfo != null) {
                logger.info("FeignInterceptor user id ->." + sessionInfo.getUserId());
                logger.info("FeignInterceptor user name ->." + sessionInfo.getUserInfo().getUserName());
                requestTemplate.header("userId", new String[]{sessionInfo.getUserId() + ""});
                requestTemplate.header("userName", new String[]{URLEncoder.encode(sessionInfo.getUserInfo().getUserName(), "UTF-8")});
            } else if (StringUtil.isNotNull(userId)) {
                logger.info("FeignInterceptor user id ->." + userId);
                requestTemplate.header("userId", new String[]{userId});
            } else if (StringUtil.isNotNull(userName)) {
                logger.info("FeignInterceptor user name ->." + userName);
                requestTemplate.header("userName", new String[]{URLEncoder.encode(userName, "UTF-8")});
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error("FeignInterceptor UnsupportedEncodingException");
        }
    }
}

