/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.exception;

import com.alibaba.fastjson.JSONObject;
import com.ztesoft.zsmart.nros.base.exception.ExceptionHandler;
import feign.Response;
import feign.Util;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import java.io.Reader;
import net.sf.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;

@Configuration
public class FeignErrorDecoder
implements ErrorDecoder {
    private Logger logger = LoggerFactory.getLogger(FeignErrorDecoder.class);

    public Exception decode(String methodKey, Response response) {
        try {
            String message = Util.toString((Reader)response.body().asReader());
            try {
                JSONObject jsonObject = JSONObject.parseObject((String)message);
                if (HttpStatus.INTERNAL_SERVER_ERROR.value() == response.status()) {
                    throw new RuntimeException();
                }
                ExceptionHandler.publish(jsonObject.getString("code"), jsonObject.getString("message"));
            }
            catch (JSONException e) {
                ExceptionHandler.publish(HttpStatus.INTERNAL_SERVER_ERROR + "", e.getMessage());
            }
        }
        catch (IOException ignored) {
            ExceptionHandler.publish(HttpStatus.INTERNAL_SERVER_ERROR + "", ignored.getMessage());
        }
        return this.decode(methodKey, response);
    }
}

