/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.aspect;

import com.ztesoft.zsmart.nros.base.annotation.DistributedLock;
import com.ztesoft.zsmart.nros.base.exception.ExceptionHandler;
import com.ztesoft.zsmart.nros.base.util.RedisLockUtils;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RedisLockAspect {
    private static final Logger log = LoggerFactory.getLogger(RedisLockAspect.class);
    private ExpressionParser parser = new SpelExpressionParser();
    @Autowired
    private RedisLockUtils redisLockUtils;

    @Pointcut(value="@annotation(com.ztesoft.zsmart.nros.base.annotation.DistributedLock)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        String className = point.getTarget().getClass().getName();
        Object[] args = point.getArgs();
        String[] paramNames = signature.getParameterNames();
        StandardEvaluationContext context = new StandardEvaluationContext();
        for (int i = 0; i < args.length; ++i) {
            context.setVariable(paramNames[i], args[i]);
        }
        DistributedLock lock = method.getAnnotation(DistributedLock.class);
        TimeUnit timeUnit = lock.timeUnit();
        long expire = timeUnit.toMillis(lock.expire());
        long waitTime = timeUnit.toMillis(lock.waitTime());
        String errorCode = lock.value();
        String key = StringUtils.isEmpty((CharSequence)lock.key()) ? method.getName() : (String)this.parser.parseExpression(lock.key()).getValue((EvaluationContext)context, String.class);
        String lockName = StringUtils.isEmpty((CharSequence)lock.lockName()) ? className : lock.lockName();
        String redisKey = lockName + "#" + key;
        boolean success = false;
        try {
            success = this.redisLockUtils.setLock(redisKey, expire, waitTime);
            if (success) {
                log.info("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u6210\u529f,class={},method={},key={}", new Object[]{className, method, redisKey});
                Object object = point.proceed();
                return object;
            }
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u4e1a\u52a1\u53d1\u751f\u9519\u8bef,class={},method={},args={}", new Object[]{className, method, args});
            throw e;
        }
        finally {
            if (success) {
                this.redisLockUtils.releaseLock(redisKey);
            }
        }
        log.info("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,class={},method={},key={}", new Object[]{className, method, redisKey});
        ExceptionHandler.publish(errorCode);
        return null;
    }
}

