/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.aspect;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.util.StringUtil;
import com.ztesoft.zsmart.nros.base.exception.AppSecretException;
import com.ztesoft.zsmart.nros.base.exception.BusiException;
import com.ztesoft.zsmart.nros.base.util.CryptoUtil;
import com.ztesoft.zsmart.nros.base.util.RuntimeContext;
import com.ztesoft.zsmart.nros.base.util.UrlUtil;
import com.ztesoft.zsmart.nros.base.util.paas.CacheUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@Aspect
@Order(value=1)
public class AppSecretAspect {
    private Logger logger = LoggerFactory.getLogger(AppSecretAspect.class);
    @Autowired
    private CacheUtils cacheUtils;
    @Value(value="${without.oauth.url.list:}")
    private String withoutOauthUrlArr;

    @Pointcut(value="@within(com.ztesoft.zsmart.nros.base.annotation.AppSecretController)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint pjp) {
        Object result = null;
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String uri = "";
        if (request.getRequestURI() != null) {
            uri = request.getRequestURI();
        }
        this.logBeforeProceed(pjp, request, uri);
        this.getAppInfoFromRequest(request);
        List<String> withoutOauthUrlList = Arrays.asList(this.withoutOauthUrlArr.split(","));
        if (!withoutOauthUrlList.contains(uri)) {
            StringBuilder api = new StringBuilder();
            api.append(request.getMethod()).append("-").append(uri);
            String apiUrl = api.toString();
            String appId = request.getHeader("appId");
            String timestamp = request.getHeader("timestamp");
            String signature = request.getHeader("signature");
            if (StringUtil.isEmpty((String)appId) || StringUtil.isEmpty((String)timestamp) || StringUtil.isEmpty((String)signature)) {
                RuntimeContext.remove();
                throw new AppSecretException(601, "\u8bf7\u4f20\u8bf7\u6c42\u5934\u4fe1\u606f");
            }
            Object res = this.cacheUtils.get("NROSAPPSECRET:" + appId);
            if (null == res || StringUtil.isEmpty((String)res.toString())) {
                RuntimeContext.remove();
                throw new AppSecretException(602, "APPID\u4e0d\u6b63\u786e");
            }
            String sign = CryptoUtil.getSHA1(appId, timestamp, res.toString());
            if (!signature.equals(sign)) {
                RuntimeContext.remove();
                throw new AppSecretException(603, "\u7b7e\u540d\u9a8c\u8bc1\u4e0d\u901a\u8fc7");
            }
            Object apiCache = this.cacheUtils.get("NROSAPPURL:" + appId);
            if (null == apiCache || !(apiCache instanceof Set) || CollectionUtils.isEmpty((Collection)((Set)apiCache))) {
                RuntimeContext.remove();
                throw new AppSecretException(403, "\u63a5\u53e3\u672a\u6388\u6743");
            }
            Set apiSet = (Set)apiCache;
            if (!apiSet.contains(apiUrl)) {
                Object apiRegexCache = this.cacheUtils.get("NROSAPPURLREGEX:" + appId);
                if (null == apiRegexCache || !(apiRegexCache instanceof Set) || CollectionUtils.isEmpty((Collection)((Set)apiRegexCache))) {
                    RuntimeContext.remove();
                    throw new AppSecretException(403, "\u63a5\u53e3\u672a\u6388\u6743");
                }
                Set apiRegexSet = (Set)apiRegexCache;
                Boolean isMatch = false;
                for (String apiUrlRegex : apiRegexSet) {
                    if (!UrlUtil.urlMatches(apiUrlRegex, apiUrl).booleanValue()) continue;
                    isMatch = true;
                    break;
                }
                if (!isMatch.booleanValue()) {
                    RuntimeContext.remove();
                    throw new AppSecretException(403, "\u63a5\u53e3\u672a\u6388\u6743");
                }
            }
        }
        long beforeMs = System.currentTimeMillis();
        try {
            result = pjp.proceed(pjp.getArgs());
        }
        catch (BusiException exception) {
            long afterMs = System.currentTimeMillis();
            this.logger.info("{} {} {} {}", new Object[]{request.getMethod(), uri, afterMs - beforeMs, HttpStatus.NOT_ACCEPTABLE.value()});
            RuntimeContext.remove();
            throw exception;
        }
        catch (Throwable appThrowable) {
            long afterMs = System.currentTimeMillis();
            this.logger.info("{} {} {} {}", new Object[]{request.getMethod(), uri, afterMs - beforeMs, HttpStatus.INTERNAL_SERVER_ERROR.value()});
            RuntimeContext.remove();
            throw new RuntimeException(appThrowable.getMessage(), appThrowable);
        }
        long afterMs = System.currentTimeMillis();
        this.logger.info("{} {} {} {}", new Object[]{request.getMethod(), uri, afterMs - beforeMs, HttpStatus.OK.value()});
        this.logger.info("response: {}", (Object)this.getResponseString(result));
        RuntimeContext.remove();
        return result;
    }

    private void getAppInfoFromRequest(HttpServletRequest request) {
        String reqAppId = request.getHeader("appId");
        RuntimeContext.put("appId", reqAppId);
        String merchantCode = request.getHeader("merchantCode");
        RuntimeContext.put("merchantCode", merchantCode);
        String userId = request.getHeader("userId");
        RuntimeContext.put("user_id", userId);
        try {
            String userName = "";
            if (StringUtils.isNotBlank((CharSequence)request.getHeader("userName"))) {
                userName = URLDecoder.decode(request.getHeader("userName"), "UTF-8");
            }
            RuntimeContext.put("user_name", userName);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("AppSecretAspect UnsupportedEncodingException");
        }
    }

    private void logBeforeProceed(ProceedingJoinPoint pjp, HttpServletRequest request, String uri) {
        try {
            String remoteIp = request.getRemoteAddr();
            String localIp = request.getLocalAddr();
            this.logger.info("{} {} {} {}", new Object[]{remoteIp, localIp, request.getMethod(), uri});
            if (StringUtils.equals((CharSequence)request.getMethod(), (CharSequence)RequestMethod.GET.toString())) {
                String parameterMapStr = this.getRequestParametersString(request);
                this.logger.info("params: {}", (Object)parameterMapStr);
            } else {
                ArrayList<Object> parms = new ArrayList<Object>();
                for (int i = 0; i < pjp.getArgs().length; ++i) {
                    if (pjp.getArgs()[i] instanceof BindingResult) continue;
                    parms.add(pjp.getArgs()[i]);
                }
                this.logger.info("params: {}", (Object)JSON.toJSONString(parms));
            }
        }
        catch (Exception e) {
            this.logger.error("\u65e5\u5fd7\u6253\u5370\u9519\u8bef\uff01");
        }
    }

    private String getRequestParametersString(HttpServletRequest request) {
        String reqParam = "null";
        reqParam = JSON.toJSONString((Object)request.getParameterMap());
        return reqParam;
    }

    private String getResponseString(Object retVal) {
        if (null == retVal) {
            return "null";
        }
        return JSON.toJSONString((Object)retVal);
    }
}

