/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.zmq.entity;

import com.aliyun.openservices.ons.api.Message;
import com.ztesoft.zsmart.nros.base.exception.BusiException;
import com.ztesoft.zsmart.nros.base.session.SessionUtils;
import com.ztesoft.zsmart.nros.base.util.IdGenerator;
import com.ztesoft.zsmart.nros.base.util.RuntimeContext;
import com.ztesoft.zsmart.nros.base.util.StringUtil;
import com.ztesoft.zsmart.nros.common.session.SessionInfo;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import net.sf.json.JSONObject;

public class NrosMQMessage {
    public static final String MSG_ID_KEY = "__nrosMsgIdInner__";
    public static final String USER_ID_KEY = "__nrosUserIdInner__";
    private String msgId;
    private String tag;
    private Long userId;
    private Message mqMessage;

    private NrosMQMessage() {
    }

    public static NrosMQMessage buildNrosMQMessage(JSONObject msgBody, String topic) {
        if (msgBody.containsKey((Object)MSG_ID_KEY)) {
            throw new BusiException("500", "NrosMQMessage buildNrosMQMessage error for [key-->__nrosMsgIdInner__] has been existed in (" + msgBody.toString() + ")");
        }
        String msgId = IdGenerator.createUUID();
        SessionInfo sessionInfo = SessionUtils.getSessionInfo();
        String userId = RuntimeContext.getValue("user_id");
        if (null != sessionInfo) {
            msgBody.put((Object)USER_ID_KEY, (Object)sessionInfo.getUserId());
        } else if (StringUtil.isNotNull(userId)) {
            msgBody.put((Object)USER_ID_KEY, (Object)userId);
        }
        return NrosMQMessage.rebuildNrosMQMessage(msgBody, topic, msgId, false);
    }

    public static NrosMQMessage buildNrosMQMessage(JSONObject msgBody, String topic, String tag) {
        if (msgBody.containsKey((Object)MSG_ID_KEY)) {
            throw new BusiException("500", "NrosMQMessage buildNrosMQMessage error for [key-->__nrosMsgIdInner__] has been existed in (" + msgBody.toString() + ")");
        }
        String msgId = IdGenerator.createUUID();
        SessionInfo sessionInfo = SessionUtils.getSessionInfo();
        String userId = RuntimeContext.getValue("user_id");
        if (null != sessionInfo) {
            msgBody.put((Object)USER_ID_KEY, (Object)sessionInfo.getUserId());
        } else if (StringUtil.isNotNull(userId)) {
            msgBody.put((Object)USER_ID_KEY, (Object)userId);
        }
        return NrosMQMessage.rebuildNrosMQMessage(msgBody, topic, msgId, false, tag);
    }

    private static NrosMQMessage rebuildNrosMQMessage(JSONObject msgBody, String topic, String msgId, boolean isExtMsg) {
        if (!isExtMsg && StringUtil.isNull(msgId)) {
            throw new BusiException("500", "NrosMQMessage msgId can not be null or empty.");
        }
        msgBody.put((Object)MSG_ID_KEY, (Object)msgId);
        Message mqMsg = null;
        try {
            mqMsg = new Message(topic, "", "", msgBody.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new BusiException("500", "Build MQMessage[" + msgBody.toString() + "]\u3000error", e);
        }
        NrosMQMessage msg = new NrosMQMessage();
        msg.setMqMessage(mqMsg);
        msg.setMsgId(msgId);
        if (msgBody.containsKey((Object)USER_ID_KEY)) {
            msg.setUserId(msgBody.getLong(USER_ID_KEY));
        }
        return msg;
    }

    private static NrosMQMessage rebuildNrosMQMessage(JSONObject msgBody, String topic, String msgId, boolean isExtMsg, String tag) {
        if (!isExtMsg && StringUtil.isNull(msgId)) {
            throw new BusiException("500", "NrosMQMessage msgId can not be null or empty.");
        }
        msgBody.put((Object)MSG_ID_KEY, (Object)msgId);
        Message mqMsg = null;
        try {
            mqMsg = new Message(topic, tag, "", msgBody.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new BusiException("500", "Build MQMessage[" + msgBody.toString() + "]\u3000error", e);
        }
        NrosMQMessage msg = new NrosMQMessage();
        msg.setMqMessage(mqMsg);
        msg.setMsgId(msgId);
        if (msgBody.containsKey((Object)USER_ID_KEY)) {
            msg.setUserId(msgBody.getLong(USER_ID_KEY));
        }
        return msg;
    }

    public static NrosMQMessage convertFromMQMessage(Message mqMsg) {
        JSONObject msgBody = null;
        try {
            msgBody = JSONObject.fromObject((Object)new String(mqMsg.getBody(), Charset.forName("UTF-8")));
        }
        catch (Exception e) {
            throw new BusiException("500", "Process MQMessage[" + new String(mqMsg.getBody(), Charset.forName("UTF-8")) + "]\u3000error", e);
        }
        String msgId = null;
        if (msgBody.containsKey((Object)MSG_ID_KEY)) {
            msgId = msgBody.getString(MSG_ID_KEY);
        } else {
            msgBody.put((Object)USER_ID_KEY, (Object)"-1");
        }
        return NrosMQMessage.rebuildNrosMQMessage(msgBody, mqMsg.getTopic(), msgId, true, mqMsg.getTag());
    }

    public String getMsgId() {
        return this.msgId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Message getMqMessage() {
        return this.mqMessage;
    }

    public void setMqMessage(Message mqMessage) {
        this.mqMessage = mqMessage;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }
}

