/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.util.excel;

import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.util.Assert;

public class MyBeanCopy {
    private static final String DATE_FORMAT = "yyyy-MM-dd";

    private static Object convertForProperty(Wrapper wrapper, Object object, Object value, String propertyName) throws TypeMismatchException {
        Object result;
        if (wrapper == null) {
            result = null;
        } else {
            wrapper.setWrappedInstance(object);
            result = wrapper.getBeanWrapper().convertForProperty(value, propertyName);
        }
        return result;
    }

    private static Object copyProperties(Object source, Object target) throws BeansException {
        MyBeanCopy myBeanCopy = new MyBeanCopy();
        myBeanCopy.getClass();
        Wrapper wrapper = myBeanCopy.new Wrapper(source);
        MyBeanCopy.copyProperties(wrapper, source, target);
        return target;
    }

    private static void copyProperties(Wrapper wrapper, Object source, Object target) throws BeansException {
        PropertyDescriptor[] targetPds;
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull((Object)target, (String)"Target must not be null");
        Class<?> actualEditable = target.getClass();
        for (PropertyDescriptor targetPd : targetPds = BeanUtils.getPropertyDescriptors(actualEditable)) {
            PropertyDescriptor sourcePd;
            if (targetPd.getWriteMethod() == null || (sourcePd = BeanUtils.getPropertyDescriptor(source.getClass(), (String)targetPd.getName())).getReadMethod() == null) continue;
            try {
                Method writeMethod;
                Object value;
                Method readMethod = sourcePd.getReadMethod();
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                if ((value = readMethod.invoke(source, new Object[0])) != null && !targetPd.getPropertyType().isInstance(value)) {
                    value = MyBeanCopy.convertForProperty(wrapper, target, value, targetPd.getName());
                }
                if (!Modifier.isPublic((writeMethod = targetPd.getWriteMethod()).getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(target, value);
            }
            catch (Exception ex) {
                throw new FatalBeanException("Could not copy properties from source to target", (Throwable)ex);
            }
        }
    }

    private static void convert(Object source, Object target) {
        MyBeanCopy.copyProperties(source, target);
    }

    public static <T> List<T> convert(List<?> sources, Class<T> targetClass) {
        List<Object> sourcesObj = sources;
        if (sourcesObj == null) {
            sourcesObj = Collections.emptyList();
        }
        ArrayList targets = new ArrayList(sourcesObj.size());
        MyBeanCopy.convert(sourcesObj, targets, targetClass);
        return targets;
    }

    private static <T> void convert(List<?> sources, List<T> targets, Class<T> targetClass) {
        if (targets == null) {
            return;
        }
        targets.clear();
        if (sources == null) {
            return;
        }
        for (Object obj : sources) {
            try {
                T target = targetClass.newInstance();
                targets.add(target);
                MyBeanCopy.convert(obj, target);
            }
            catch (Exception e) {
                return;
            }
        }
    }

    private final class Wrapper {
        private GenericConversionService conversion = this.initDefaultConversionService();
        private BeanWrapperImpl bean;

        private Wrapper(Object object) {
            this.bean = this.initDefaultBeanWrapper((ConversionService)this.conversion, object);
        }

        private void setWrappedInstance(Object object) {
            this.bean.setWrappedInstance(object);
        }

        private GenericConversionService initDefaultConversionService() {
            DefaultConversionService conversionService = new DefaultConversionService();
            conversionService.addConverter((Converter)new DateToStringConverter(MyBeanCopy.DATE_FORMAT));
            return conversionService;
        }

        private BeanWrapperImpl initDefaultBeanWrapper(ConversionService conversion, Object object) {
            BeanWrapperImpl beanWrapper = new BeanWrapperImpl(object);
            beanWrapper.setConversionService(conversion);
            SimpleDateFormat dateFormat = new SimpleDateFormat(MyBeanCopy.DATE_FORMAT);
            dateFormat.setLenient(false);
            beanWrapper.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)dateFormat, true));
            return beanWrapper;
        }

        private BeanWrapperImpl getBeanWrapper() {
            return this.bean;
        }
    }

    private final class DateToStringConverter
    implements Converter<Date, String> {
        private DateFormat df;

        private DateToStringConverter(String format) {
            this.df = new SimpleDateFormat(format);
        }

        public String convert(Date source) {
            return this.df.format(source);
        }
    }
}

