/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static ObjectMapper mapper = new ObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(JsonUtil.class);
    public static JsonConfig jsonConfig = null;

    private JsonUtil() {
    }

    public static JsonNode string2JsonObj(String str) throws JsonParseException, JsonMappingException, IOException {
        return mapper.readTree(str);
    }

    public static String getValue(JsonNode node, String key, String defaultValue) {
        JsonNode tmpNode = node.get(key);
        if (tmpNode == null) {
            return defaultValue;
        }
        return tmpNode.asText();
    }

    public static String getValue(JsonNode node, String key) {
        return JsonUtil.getValue(node, key, null);
    }

    public static String bean2JsonStr(Object obj) {
        String retStr = "";
        try {
            ObjectWriter objectWriter = mapper.writer().withDefaultPrettyPrinter();
            retStr = objectWriter.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            log.error("Convert bean2JsonStr exception.", (Throwable)e);
        }
        return retStr;
    }

    public static String map2JsonStr(Map<String, Object> map) {
        String retStr = "";
        try {
            retStr = mapper.writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            log.error("Convert map2JsonStr exception.", (Throwable)e);
        }
        return retStr;
    }

    public static <T> T fromJson(String jsonStr, Class<T> objClass) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (T)mapper.readValue(jsonStr, objClass);
        }
        catch (IOException ex) {
            log.error("Parser to object error.", (Throwable)ex);
            throw new IllegalArgumentException("Parser json to object error, json = " + jsonStr + ", expect class = " + objClass, ex);
        }
    }

    public static <T> T fromJson(String jsonStr, TypeReference<T> typeRef) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (T)mapper.readValue(jsonStr, typeRef);
        }
        catch (IOException ex) {
            log.error("Parser to object by type reference error.", (Throwable)ex);
            throw new IllegalArgumentException("Parser json to object error, json = " + jsonStr + ", expect type = " + typeRef.getType(), ex);
        }
    }

    public static JSONObject map2Json(Map<String, Object> map) {
        JSONObject json = null;
        json = JSONObject.fromObject(map);
        return json;
    }

    public static JSONObject str2Json(String str) {
        JSONObject json = null;
        json = JSONObject.fromObject((Object)str);
        return json;
    }

    public static JSONArray str2JsonArray(String str) {
        JSONArray array = null;
        array = JSONArray.fromObject((Object)str);
        return array;
    }

    public static JSONArray getArray(JSONObject json, String key) {
        if (json.containsKey((Object)key)) {
            return json.getJSONArray(key);
        }
        return new JSONArray();
    }

    public static JSONObject getObject(JSONObject json, String key) {
        if (json.containsKey((Object)key)) {
            return json.getJSONObject(key);
        }
        return new JSONObject();
    }

    public static String getValue(JSONObject json, String key, String defaultValue) {
        if (!json.containsKey((Object)key) || json.get(key) == null) {
            return defaultValue;
        }
        return json.getString(key);
    }

    public static String getValue(JSONObject json, String key) {
        return JsonUtil.getValue(json, key, null);
    }

    public static boolean isNull(JSONObject json) {
        return json == null || json.isNullObject() || json.isEmpty();
    }

    public static Map<String, Object> json2Map(JsonNode node) {
        HashMap<String, Object> map = new HashMap();
        map = (Map)mapper.convertValue((Object)node, Map.class);
        return map;
    }

    public static void addValue2JSONObject(JSONObject json, String key, Object value) {
        json.element(key, value, jsonConfig);
    }

    public static void addObject2JSONArray(JSONArray array, Object obj) {
        array.add(obj, jsonConfig);
    }

    static {
        jsonConfig = new JsonConfig();
        jsonConfig.registerJsonValueProcessor(String.class, new JsonValueProcessor(){

            public Object processObjectValue(String key, Object value, JsonConfig jsonConfig) {
                String str = (String)value;
                if (str.startsWith("[") && str.endsWith("]") || str.startsWith("{") && str.endsWith("}")) {
                    return "\"" + str + "\"";
                }
                return str;
            }

            public Object processArrayValue(Object value, JsonConfig jsonConfig) {
                String str = (String)value;
                if (str.startsWith("[") && str.endsWith("]") || str.startsWith("{") && str.endsWith("}")) {
                    return "\"" + str + "\"";
                }
                return str;
            }
        });
    }
}

