/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.util;

import com.github.pagehelper.PageInfo;
import com.ztesoft.zsmart.nros.base.model.ResponseMsg;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonFunctions {
    private static final Logger log = LoggerFactory.getLogger(CommonFunctions.class);

    public static <T> ResponseMsg<List<T>> runSupplierByPage(Supplier<PageInfo<T>> supplier, String errorMsg) {
        ResponseMsg<List<List>> responseMsg = new ResponseMsg<List<List>>();
        PageInfo<T> page = supplier.get();
        responseMsg.setData(page.getList());
        responseMsg.setPageIndex(page.getPageNum());
        responseMsg.setPageSize(page.getPageSize());
        responseMsg.setTotal(page.getTotal());
        responseMsg.setSuccess(true);
        return responseMsg;
    }

    public static <T> ResponseMsg<List<T>> runSupplierByList(Supplier<List<T>> supplier, String errorMsg) {
        ResponseMsg<List<List<T>>> responseMsg = new ResponseMsg<List<List<T>>>();
        List<T> data = supplier.get();
        responseMsg.setData(data);
        responseMsg.setSuccess(true);
        return responseMsg;
    }

    public static <T> ResponseMsg<T> runSupplier(Supplier<T> supplier, String errorMsg) {
        ResponseMsg<T> responseMsg = new ResponseMsg<T>();
        T data = supplier.get();
        responseMsg.setData(data);
        responseMsg.setSuccess(true);
        return responseMsg;
    }

    public static ResponseMsg runSupplierByVoid(Supplier supplier, String errorMsg) {
        ResponseMsg responseMsg = new ResponseMsg();
        supplier.get();
        responseMsg.setSuccess(true);
        return responseMsg;
    }

    public static <S, T> ResponseMsg<List<T>> runTranslateByPage(ResponseMsg<PageInfo<S>> responseMsg, Supplier<List<T>> translate) {
        ResponseMsg<List<List<T>>> data = new ResponseMsg<List<List<T>>>();
        PageInfo<S> page = responseMsg.getData();
        List<T> vos = translate.get();
        data.setData(vos);
        data.setPageIndex(page.getPageNum());
        data.setPageSize(page.getPageSize());
        data.setTotal(page.getTotal());
        data.setSuccess(true);
        return data;
    }

    public static <S, T> ResponseMsg<List<T>> runTranslateByList(ResponseMsg<List<S>> responseMsg, Supplier<List<T>> translate) {
        ResponseMsg<List<List<T>>> data = new ResponseMsg<List<List<T>>>();
        List<T> vos = translate.get();
        data.setData(vos);
        data.setPageIndex(responseMsg.getPageIndex());
        data.setPageSize(responseMsg.getPageSize());
        data.setTotal(responseMsg.getTotal());
        data.setSuccess(true);
        return data;
    }
}

