/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.github.pagehelper.PageHelper;
import com.taobao.txc.datasource.cobar.TxcDataSource;
import com.ztesoft.zsmart.nros.base.interceptor.AutoInFieldInterceptor;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.AutoMappingBehavior;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@ConditionalOnProperty(value={"mybatis.enabled"}, havingValue="true")
@MapperScan(basePackages={"com.ztesoft.zsmart.nros.*.**.dao"}, sqlSessionFactoryRef="sqlSessionFactory")
public class MyBatisConfig {
    @Value(value="${mybatis.mapper-locations}")
    private String mapperLocation;

    @Bean
    PageHelper pageHelper() {
        PageHelper pageHelper = new PageHelper();
        Properties properties = new Properties();
        properties.setProperty("reasonable", "true");
        properties.setProperty("supportMethodsArguments", "true");
        properties.setProperty("returnPageInfo", "check");
        properties.setProperty("params", "count=countSql");
        pageHelper.setProperties(properties);
        return pageHelper;
    }

    @ConfigurationProperties(prefix="spring.datasource.druid")
    @Bean
    public DruidDataSource dataSource() {
        return new DruidDataSource();
    }

    @Bean(value={"dataSourceProxy"})
    public TxcDataSource dataSourceProxy(DruidDataSource dataSource) {
        return new TxcDataSource((DataSource)dataSource);
    }

    @Bean(value={"jdbcTemplate"})
    @ConditionalOnBean(value={TxcDataSource.class})
    public JdbcTemplate jdbcTemplate(TxcDataSource dataSourceProxy) {
        return new JdbcTemplate((DataSource)dataSourceProxy);
    }

    @Bean
    public DataSourceTransactionManager transactionManagerCommonunity(@Qualifier(value="dataSourceProxy") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean(value={"sqlSessionFactory"})
    public SqlSessionFactoryBean sqlSessionFactory(@Qualifier(value="dataSourceProxy") DataSource dataSource) throws Exception {
        SqlSessionFactoryBean sqlSessionFactoryBean = new SqlSessionFactoryBean();
        sqlSessionFactoryBean.setDataSource(dataSource);
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        sqlSessionFactoryBean.setMapperLocations(resolver.getResources(this.mapperLocation));
        org.apache.ibatis.session.Configuration configuration = this.getConfiguration();
        configuration.addInterceptor((Interceptor)new AutoInFieldInterceptor());
        sqlSessionFactoryBean.setConfiguration(configuration);
        return sqlSessionFactoryBean;
    }

    public org.apache.ibatis.session.Configuration getConfiguration() {
        org.apache.ibatis.session.Configuration configuration = new org.apache.ibatis.session.Configuration();
        configuration.setMapUnderscoreToCamelCase(true);
        configuration.setAutoMappingBehavior(AutoMappingBehavior.FULL);
        return configuration;
    }
}

