/*
 * Decompiled with CFR 0.152.
 */
package com.ztesoft.zsmart.nros.base.aspect;

import com.alibaba.fastjson.JSON;
import com.ztesoft.zsmart.nros.base.exception.BusiException;
import com.ztesoft.zsmart.nros.base.model.AppInfo;
import com.ztesoft.zsmart.nros.base.util.RuntimeContext;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@Aspect
@Order(value=1)
public class CenterAspect {
    private Logger logger = LoggerFactory.getLogger(CenterAspect.class);
    @Autowired
    private AppInfo appInfo;

    @Around(value="@within(com.ztesoft.zsmart.nros.base.annotation.CenterController)")
    public Object around(ProceedingJoinPoint joinPoint) {
        if (!this.isRestRequestHandleMethod(joinPoint)) {
            try {
                return joinPoint.proceed();
            }
            catch (BusiException exception) {
                throw exception;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable.getMessage(), throwable);
            }
        }
        return this.aroundBizRequestHandleMethod(joinPoint);
    }

    private boolean isRestRequestHandleMethod(ProceedingJoinPoint joinPoint) {
        Class<?>[] clazzes;
        Annotation[] annotations;
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method targetMethod = methodSignature.getMethod();
        for (Annotation annotation : annotations = targetMethod.getAnnotations()) {
            if (!annotation.annotationType().equals(RequestMapping.class) && !annotation.annotationType().equals(GetMapping.class) && !annotation.annotationType().equals(PutMapping.class) && !annotation.annotationType().equals(DeleteMapping.class) && !annotation.annotationType().equals(PostMapping.class)) continue;
            return true;
        }
        for (Class<?> clazz : clazzes = targetMethod.getDeclaringClass().getInterfaces()) {
            try {
                Annotation[] annotations1;
                Method interfaceMethod = clazz.getMethod(targetMethod.getName(), targetMethod.getParameterTypes());
                for (Annotation annotation : annotations1 = interfaceMethod.getAnnotations()) {
                    if (!annotation.annotationType().equals(RequestMapping.class) && !annotation.annotationType().equals(GetMapping.class) && !annotation.annotationType().equals(PutMapping.class) && !annotation.annotationType().equals(DeleteMapping.class) && !annotation.annotationType().equals(PostMapping.class)) continue;
                    return true;
                }
            }
            catch (Exception e) {
                this.logger.warn("Get Interface method annotation exception", (Throwable)e);
            }
        }
        return false;
    }

    private void getAppInfoFromRequest(HttpServletRequest request) {
        String appPath = request.getHeader("App-Path");
        RuntimeContext.put("App-Path", appPath);
        String reqAppId = request.getHeader("appId");
        RuntimeContext.put("appId", reqAppId);
        String reqId = request.getHeader("ReqId");
        RuntimeContext.put("ReqId", reqId);
        String merchantCode = request.getHeader("merchantCode");
        RuntimeContext.put("merchantCode", merchantCode);
        String userId = request.getHeader("userId");
        RuntimeContext.put("user_id", userId);
        try {
            String userName = "";
            if (StringUtils.isNotBlank((CharSequence)request.getHeader("userName"))) {
                userName = URLDecoder.decode(request.getHeader("userName"), "UTF-8");
            }
            RuntimeContext.put("user_name", userName);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("FeignInterceptor UnsupportedEncodingException");
        }
    }

    protected Object aroundBizRequestHandleMethod(ProceedingJoinPoint joinPoint) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String uri = "";
        if (request.getRequestURI() != null) {
            uri = request.getRequestURI();
        }
        this.logBeforeProceed(joinPoint, request, uri);
        this.getAppInfoFromRequest(request);
        long beforeMs = System.currentTimeMillis();
        Object ret = null;
        try {
            ret = joinPoint.proceed();
        }
        catch (BusiException exception) {
            long afterMs = System.currentTimeMillis();
            this.logger.info("{} {} {} {}", new Object[]{request.getMethod(), uri, afterMs - beforeMs, HttpStatus.NOT_ACCEPTABLE.value()});
            RuntimeContext.remove();
            throw exception;
        }
        catch (Throwable throwable) {
            long afterMs = System.currentTimeMillis();
            this.logger.info("{} {} {} {}", new Object[]{request.getMethod(), uri, afterMs - beforeMs, HttpStatus.INTERNAL_SERVER_ERROR.value()});
            RuntimeContext.remove();
            throw new RuntimeException(throwable.getMessage(), throwable);
        }
        long afterMs = System.currentTimeMillis();
        this.logger.info("{} {} {} {}", new Object[]{request.getMethod(), uri, afterMs - beforeMs, HttpStatus.OK.value()});
        this.logger.info("response: {}", (Object)this.getResponseString(ret));
        RuntimeContext.remove();
        return ret;
    }

    private void logBeforeProceed(ProceedingJoinPoint pjp, HttpServletRequest request, String uri) {
        try {
            String remoteIp = request.getRemoteAddr();
            String localIp = request.getLocalAddr();
            this.logger.info("{} {} {} {}", new Object[]{remoteIp, localIp, request.getMethod(), uri});
            if (StringUtils.equals((CharSequence)request.getMethod(), (CharSequence)RequestMethod.GET.toString())) {
                String parameterMapStr = this.getRequestParametersString(request);
                this.logger.info("params: {}", (Object)parameterMapStr);
            } else {
                ArrayList<Object> parms = new ArrayList<Object>();
                for (int i = 0; i < pjp.getArgs().length; ++i) {
                    if (pjp.getArgs()[i] instanceof BindingResult) continue;
                    parms.add(pjp.getArgs()[i]);
                }
                this.logger.info("params: {}", (Object)JSON.toJSONString(parms));
            }
        }
        catch (Exception e) {
            this.logger.error("\u65e5\u5fd7\u6253\u5370\u9519\u8bef\uff01");
        }
    }

    private String getRequestParametersString(HttpServletRequest request) {
        String reqParam = "null";
        reqParam = JSON.toJSONString((Object)request.getParameterMap());
        return reqParam;
    }

    private String getResponseString(Object retVal) {
        if (null == retVal) {
            return "null";
        }
        return JSON.toJSONString((Object)retVal);
    }
}

