/*
 * Decompiled with CFR 0.152.
 */
package com.zhoyq.server.jt808.starter.pack;

import com.zhoyq.server.jt808.starter.core.Jt808Pack;
import com.zhoyq.server.jt808.starter.core.PackHandler;
import com.zhoyq.server.jt808.starter.helper.ByteArrHelper;
import com.zhoyq.server.jt808.starter.helper.GzipHelper;
import com.zhoyq.server.jt808.starter.helper.ResHelper;
import com.zhoyq.server.jt808.starter.service.DataService;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Jt808Pack(msgId=2305)
public class Handler0x0901
implements PackHandler {
    private static final Logger log = LoggerFactory.getLogger(Handler0x0901.class);
    private DataService dataService;
    private ThreadPoolExecutor tpe;
    private ByteArrHelper byteArrHelper;
    private ResHelper resHelper;
    private GzipHelper gzipHelper;

    @Override
    public byte[] handle(byte[] phoneNum, byte[] streamNum, byte[] msgId, byte[] msgBody) {
        log.info("0901 \u6570\u636e\u538b\u7f29\u4e0a\u62a5 DataPressUpload");
        this.tpe.execute(() -> {
            String phone = this.byteArrHelper.toHexString(phoneNum);
            byte[] data = this.gzipHelper.ungzip(this.byteArrHelper.subByte(msgBody, 4));
            this.dataService.compressData(phone, data);
        });
        return this.resHelper.getPlatAnswer(phoneNum, streamNum, msgId, (byte)0);
    }

    public Handler0x0901(DataService dataService, ThreadPoolExecutor tpe, ByteArrHelper byteArrHelper, ResHelper resHelper, GzipHelper gzipHelper) {
        this.dataService = dataService;
        this.tpe = tpe;
        this.byteArrHelper = byteArrHelper;
        this.resHelper = resHelper;
        this.gzipHelper = gzipHelper;
    }
}

