/*
 * Decompiled with CFR 0.152.
 */
package com.zhoyq.server.jt808.starter.pack;

import com.zhoyq.server.jt808.starter.core.Jt808Pack;
import com.zhoyq.server.jt808.starter.core.PackHandler;
import com.zhoyq.server.jt808.starter.entity.DataTransportInfo;
import com.zhoyq.server.jt808.starter.helper.Analyzer;
import com.zhoyq.server.jt808.starter.helper.ByteArrHelper;
import com.zhoyq.server.jt808.starter.helper.ResHelper;
import com.zhoyq.server.jt808.starter.service.DataService;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Jt808Pack(msgId=2304)
public class Handler0x0900
implements PackHandler {
    private static final Logger log = LoggerFactory.getLogger(Handler0x0900.class);
    private DataService dataService;
    private ThreadPoolExecutor tpe;
    private ByteArrHelper byteArrHelper;
    private ResHelper resHelper;
    private Analyzer analyzer;

    @Override
    public byte[] handle(byte[] phoneNum, byte[] streamNum, byte[] msgId, byte[] msgBody) {
        log.info("0900 \u6570\u636e\u4e0a\u884c\u900f\u4f20 DataTransport");
        this.tpe.execute(() -> {
            String phone = this.byteArrHelper.toHexString(phoneNum);
            DataTransportInfo dataTransportInfo = this.analyzer.analyzeDataTransport(msgBody);
            this.dataService.dataTransport(phone, dataTransportInfo);
        });
        return this.resHelper.getPlatAnswer(phoneNum, streamNum, msgId, (byte)0);
    }

    public Handler0x0900(DataService dataService, ThreadPoolExecutor tpe, ByteArrHelper byteArrHelper, ResHelper resHelper, Analyzer analyzer) {
        this.dataService = dataService;
        this.tpe = tpe;
        this.byteArrHelper = byteArrHelper;
        this.resHelper = resHelper;
        this.analyzer = analyzer;
    }
}

