/*
 * Decompiled with CFR 0.152.
 */
package com.zhoyq.server.jt808.starter.pack;

import com.zhoyq.server.jt808.starter.core.Jt808Pack;
import com.zhoyq.server.jt808.starter.core.PackHandler;
import com.zhoyq.server.jt808.starter.entity.LocationInfo;
import com.zhoyq.server.jt808.starter.entity.MediaInfo;
import com.zhoyq.server.jt808.starter.helper.Analyzer;
import com.zhoyq.server.jt808.starter.helper.ByteArrHelper;
import com.zhoyq.server.jt808.starter.helper.Jt808Helper;
import com.zhoyq.server.jt808.starter.helper.ResHelper;
import com.zhoyq.server.jt808.starter.service.DataService;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Jt808Pack(msgId=2049)
public class Handler0x0801
implements PackHandler {
    private static final Logger log = LoggerFactory.getLogger(Handler0x0801.class);
    private DataService dataService;
    private ThreadPoolExecutor tpe;
    private ByteArrHelper byteArrHelper;
    private ResHelper resHelper;
    private Analyzer analyzer;
    private Jt808Helper jt808Helper;

    @Override
    public byte[] handle(byte[] phoneNum, byte[] streamNum, byte[] msgId, byte[] msgBody) {
        log.info("0801 \u591a\u5a92\u4f53\u6570\u636e\u4e0a\u4f20 MediaInfoUpload");
        this.tpe.execute(() -> {
            byte[] mediaData;
            String phone = this.byteArrHelper.toHexString(phoneNum);
            byte[] mediaInfoData = this.byteArrHelper.subByte(msgBody, 0, 8);
            byte[] locationData = this.byteArrHelper.subByte(msgBody, 8, 36);
            if (phoneNum.length == 10) {
                mediaData = this.byteArrHelper.subByte(msgBody, 36);
            } else {
                boolean isLocationData = this.jt808Helper.checkLocationData(locationData);
                if (isLocationData) {
                    mediaData = this.byteArrHelper.subByte(msgBody, 36);
                } else {
                    locationData = null;
                    mediaData = this.byteArrHelper.subByte(msgBody, 8);
                }
            }
            MediaInfo mediaInfo = this.analyzer.analyzeMediaInfo(mediaInfoData);
            this.dataService.mediaInfo(phone, mediaInfo);
            if (locationData != null) {
                LocationInfo locationInfo = this.analyzer.analyzeLocation(locationData);
                this.dataService.terminalLocation(phone, locationInfo);
            }
            this.dataService.mediaPackage(phone, mediaData);
        });
        return this.resHelper.getPlatAnswer(phoneNum, streamNum, msgId, (byte)0);
    }

    public Handler0x0801(DataService dataService, ThreadPoolExecutor tpe, ByteArrHelper byteArrHelper, ResHelper resHelper, Analyzer analyzer, Jt808Helper jt808Helper) {
        this.dataService = dataService;
        this.tpe = tpe;
        this.byteArrHelper = byteArrHelper;
        this.resHelper = resHelper;
        this.analyzer = analyzer;
        this.jt808Helper = jt808Helper;
    }
}

