/*
 * Decompiled with CFR 0.152.
 */
package com.zhoyq.server.jt808.starter.pack;

import com.zhoyq.server.jt808.starter.core.Jt808Pack;
import com.zhoyq.server.jt808.starter.core.PackHandler;
import com.zhoyq.server.jt808.starter.entity.LocationInfo;
import com.zhoyq.server.jt808.starter.helper.Analyzer;
import com.zhoyq.server.jt808.starter.helper.ByteArrHelper;
import com.zhoyq.server.jt808.starter.helper.ResHelper;
import com.zhoyq.server.jt808.starter.service.DataService;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Jt808Pack(msgId=1796)
public class Handler0x0704
implements PackHandler {
    private static final Logger log = LoggerFactory.getLogger(Handler0x0704.class);
    private DataService dataService;
    private ThreadPoolExecutor tpe;
    private ByteArrHelper byteArrHelper;
    private ResHelper resHelper;
    private Analyzer analyzer;

    @Override
    public byte[] handle(byte[] phoneNum, byte[] streamNum, byte[] msgId, byte[] msgBody) {
        log.info("0704 \u5b9a\u4f4d\u6570\u636e\u6279\u91cf\u4e0a\u4f20  LocationDataUploadBatch");
        this.tpe.execute(() -> {
            int len;
            String phone = this.byteArrHelper.toHexString(phoneNum);
            for (int pos = 3; pos < msgBody.length; pos += len + 2) {
                len = this.byteArrHelper.twobyte2int(this.byteArrHelper.subByte(msgBody, pos, pos + 2));
                byte[] data = this.byteArrHelper.subByte(msgBody, pos + 2, pos + 2 + len);
                LocationInfo locationInfo = this.analyzer.analyzeLocation(data);
                this.dataService.terminalLocation(phone, locationInfo);
            }
        });
        return this.resHelper.getPlatAnswer(phoneNum, streamNum, msgId, (byte)0);
    }

    public Handler0x0704(DataService dataService, ThreadPoolExecutor tpe, ByteArrHelper byteArrHelper, ResHelper resHelper, Analyzer analyzer) {
        this.dataService = dataService;
        this.tpe = tpe;
        this.byteArrHelper = byteArrHelper;
        this.resHelper = resHelper;
        this.analyzer = analyzer;
    }
}

