/*
 * Decompiled with CFR 0.152.
 */
package com.zhoyq.server.jt808.starter.pack;

import com.zhoyq.server.jt808.starter.core.Jt808Pack;
import com.zhoyq.server.jt808.starter.core.PackHandler;
import com.zhoyq.server.jt808.starter.entity.DriverInfo;
import com.zhoyq.server.jt808.starter.helper.Analyzer;
import com.zhoyq.server.jt808.starter.helper.ByteArrHelper;
import com.zhoyq.server.jt808.starter.helper.ResHelper;
import com.zhoyq.server.jt808.starter.service.DataService;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Jt808Pack(msgId=1794)
public class Handler0x0702
implements PackHandler {
    private static final Logger log = LoggerFactory.getLogger(Handler0x0702.class);
    private DataService dataService;
    private ThreadPoolExecutor tpe;
    private ByteArrHelper byteArrHelper;
    private ResHelper resHelper;
    private Analyzer analyzer;

    @Override
    public byte[] handle(byte[] phoneNum, byte[] streamNum, byte[] msgId, byte[] msgBody) {
        log.info("0702 \u9a7e\u9a76\u5458\u8eab\u4efd\u4fe1\u606f\u91c7\u96c6\u4e0a\u62a5 driver data collection report");
        DriverInfo driverInfo = this.analyzer.analyzeDriver(phoneNum, msgBody);
        if (driverInfo == null) {
            return this.resHelper.getPlatAnswer(phoneNum, streamNum, msgId, (byte)1);
        }
        this.tpe.execute(() -> {
            String phone = this.byteArrHelper.toHexString(phoneNum);
            this.dataService.driverInfo(phone, driverInfo);
        });
        return this.resHelper.getPlatAnswer(phoneNum, streamNum, msgId, (byte)0);
    }

    public Handler0x0702(DataService dataService, ThreadPoolExecutor tpe, ByteArrHelper byteArrHelper, ResHelper resHelper, Analyzer analyzer) {
        this.dataService = dataService;
        this.tpe = tpe;
        this.byteArrHelper = byteArrHelper;
        this.resHelper = resHelper;
        this.analyzer = analyzer;
    }
}

