/*
 * Decompiled with CFR 0.152.
 */
package com.zhoyq.server.jt808.starter.pack;

import com.zhoyq.server.jt808.starter.core.Jt808Pack;
import com.zhoyq.server.jt808.starter.core.PackHandler;
import com.zhoyq.server.jt808.starter.helper.ByteArrHelper;
import com.zhoyq.server.jt808.starter.helper.Jt808Helper;
import com.zhoyq.server.jt808.starter.helper.ResHelper;
import com.zhoyq.server.jt808.starter.service.CacheService;
import com.zhoyq.server.jt808.starter.service.DataService;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Jt808Pack(msgId=258)
public class Handler0x0102
implements PackHandler {
    private static final Logger log = LoggerFactory.getLogger(Handler0x0102.class);
    private CacheService cacheService;
    private DataService dataService;
    private ThreadPoolExecutor tpe;
    private ByteArrHelper byteArrHelper;
    private Jt808Helper jt808Helper;
    private ResHelper resHelper;

    @Override
    public byte[] handle(byte[] phoneNum, byte[] streamNum, byte[] msgId, byte[] msgBody) {
        byte result;
        String authId;
        log.info("0102 \u7ec8\u7aef\u9274\u6743  TerminalAuthentication");
        int version = phoneNum.length == 10 ? 2019 : 20132011;
        String phone = this.byteArrHelper.toHexString(phoneNum);
        if (version == 2019) {
            byte len = msgBody[0];
            try {
                authId = this.jt808Helper.toGBKString(this.byteArrHelper.subByte(msgBody, 1, 1 + len));
            }
            catch (UnsupportedEncodingException e) {
                log.warn(e.getMessage());
                authId = null;
            }
        } else {
            try {
                authId = this.jt808Helper.toGBKString(msgBody);
            }
            catch (UnsupportedEncodingException e) {
                log.warn(e.getMessage());
                authId = null;
            }
        }
        String oriAuthId = this.cacheService.getAuth(phone);
        if (oriAuthId != null && oriAuthId.equals(authId)) {
            result = 0;
            if (version == 2019) {
                this.tpe.execute(() -> {
                    byte[] imei = this.byteArrHelper.subByte(msgBody, msgBody[0] + 1, msgBody[0] + 16);
                    byte[] softVersion = this.byteArrHelper.subByte(msgBody, msgBody[0] + 16, msgBody[0] + 36);
                    this.dataService.terminalAuth(phone, oriAuthId, this.jt808Helper.toAsciiString(imei), this.jt808Helper.toAsciiString(softVersion));
                });
            } else {
                this.tpe.execute(() -> this.dataService.terminalAuth(phone, oriAuthId, null, null));
            }
        } else {
            result = 1;
        }
        return this.resHelper.getPlatAnswer(phoneNum, streamNum, msgId, result);
    }

    public Handler0x0102(CacheService cacheService, DataService dataService, ThreadPoolExecutor tpe, ByteArrHelper byteArrHelper, Jt808Helper jt808Helper, ResHelper resHelper) {
        this.cacheService = cacheService;
        this.dataService = dataService;
        this.tpe = tpe;
        this.byteArrHelper = byteArrHelper;
        this.jt808Helper = jt808Helper;
        this.resHelper = resHelper;
    }
}

