/*
 * Decompiled with CFR 0.152.
 */
package com.zhoyq.server.jt808.starter.pack;

import com.zhoyq.server.jt808.starter.core.Jt808Pack;
import com.zhoyq.server.jt808.starter.core.PackHandler;
import com.zhoyq.server.jt808.starter.helper.ByteArrHelper;
import com.zhoyq.server.jt808.starter.helper.Jt808Helper;
import com.zhoyq.server.jt808.starter.helper.ResHelper;
import com.zhoyq.server.jt808.starter.service.CacheService;
import com.zhoyq.server.jt808.starter.service.DataService;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Jt808Pack(msgId=256)
public class Handler0x0100
implements PackHandler {
    private static final Logger log = LoggerFactory.getLogger(Handler0x0100.class);
    private DataService dataService;
    private CacheService cacheService;
    private ThreadPoolExecutor tpe;
    private ByteArrHelper byteArrHelper;
    private ResHelper resHelper;
    private Jt808Helper jt808Helper;

    @Override
    public byte[] handle(byte[] phoneNum, byte[] streamNum, byte[] msgId, byte[] msgBody) {
        String str;
        log.info("0100 \u7ec8\u7aef\u6ce8\u518c TerminalRegister");
        int version = phoneNum.length == 10 ? 2019 : (msgBody.length > 37 ? 2013 : 2011);
        String phone = this.byteArrHelper.toHexString(phoneNum);
        int offset = 0;
        byte[] provinceId = this.byteArrHelper.subByte(msgBody, offset, offset += 2);
        byte[] cityId = this.byteArrHelper.subByte(msgBody, offset, offset += 2);
        byte[] producerId = version == 2019 ? this.byteArrHelper.subByte(msgBody, offset, offset += 11) : this.byteArrHelper.subByte(msgBody, offset, offset += 5);
        byte[] terminalType = version == 2019 ? this.byteArrHelper.subByte(msgBody, offset, offset += 30) : (version == 2013 ? this.byteArrHelper.subByte(msgBody, offset, offset += 20) : this.byteArrHelper.subByte(msgBody, offset, offset += 8));
        byte[] terminalId = version == 2019 ? this.byteArrHelper.subByte(msgBody, offset, offset += 30) : this.byteArrHelper.subByte(msgBody, offset, offset += 7);
        byte[] licenseColor = this.byteArrHelper.subByte(msgBody, offset++, offset);
        byte[] license = this.byteArrHelper.subByte(msgBody, offset);
        Future<String> authFuture = this.tpe.submit(() -> {
            int province = this.byteArrHelper.twobyte2int(provinceId);
            int city = this.byteArrHelper.twobyte2int(cityId);
            String manufacturer = null;
            String deviceType = null;
            String deviceId = null;
            String registerLicense = null;
            try {
                manufacturer = this.jt808Helper.toAsciiString(producerId);
                deviceType = this.jt808Helper.toAsciiString(terminalType);
                deviceId = this.jt808Helper.toAsciiString(terminalId);
                registerLicense = this.jt808Helper.toGBKString(license);
            }
            catch (UnsupportedEncodingException e) {
                log.warn(e.getMessage());
            }
            return this.dataService.terminalRegister(phone, province, city, manufacturer, deviceType, deviceId, licenseColor[0], registerLicense);
        });
        try {
            str = authFuture.get();
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            log.warn("\u9274\u6743\u7801\u83b7\u53d6\u5931\u8d25\uff01");
            str = null;
        }
        if (str == null) {
            return this.resHelper.getPlatAnswer(phoneNum, streamNum, msgId, (byte)1);
        }
        if ("0000001".equals(str)) {
            return this.resHelper.getTerminalRegisterAnswer(phoneNum, streamNum, (byte)1, str);
        }
        if ("0000002".equals(str)) {
            return this.resHelper.getTerminalRegisterAnswer(phoneNum, streamNum, (byte)2, str);
        }
        if ("0000003".equals(str)) {
            return this.resHelper.getTerminalRegisterAnswer(phoneNum, streamNum, (byte)3, str);
        }
        if ("0000004".equals(str)) {
            return this.resHelper.getTerminalRegisterAnswer(phoneNum, streamNum, (byte)4, str);
        }
        this.cacheService.setAuth(phone, str);
        return this.resHelper.getTerminalRegisterAnswer(phoneNum, streamNum, (byte)0, str);
    }

    public Handler0x0100(DataService dataService, CacheService cacheService, ThreadPoolExecutor tpe, ByteArrHelper byteArrHelper, ResHelper resHelper, Jt808Helper jt808Helper) {
        this.dataService = dataService;
        this.cacheService = cacheService;
        this.tpe = tpe;
        this.byteArrHelper = byteArrHelper;
        this.resHelper = resHelper;
        this.jt808Helper = jt808Helper;
    }
}

