/*
 * Decompiled with CFR 0.152.
 */
package com.zhoyq.server.jt808.starter.pack;

import com.zhoyq.server.jt808.starter.core.Jt808Pack;
import com.zhoyq.server.jt808.starter.core.PackHandler;
import com.zhoyq.server.jt808.starter.core.SessionManagement;
import com.zhoyq.server.jt808.starter.helper.ByteArrHelper;
import com.zhoyq.server.jt808.starter.helper.ResHelper;
import com.zhoyq.server.jt808.starter.service.CacheService;
import io.netty.channel.ChannelHandlerContext;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Jt808Pack(msgId=5)
public class Handler0x0005
implements PackHandler {
    private static final Logger log = LoggerFactory.getLogger(Handler0x0005.class);
    private CacheService cacheService;
    private SessionManagement sessionManagement;
    private ThreadPoolExecutor tpe;
    private ByteArrHelper byteArrHelper;
    private ResHelper resHelper;

    @Override
    public byte[] handle(byte[] phoneNum, byte[] streamNum, byte[] msgId, byte[] msgBody) {
        log.info("0005 \u7ec8\u7aef\u8865\u4f20\u5206\u5305\u8bf7\u6c42 terminal request patch");
        this.tpe.execute(() -> {
            String phone = this.byteArrHelper.toHexString(phoneNum);
            Map<Integer, byte[]> sentPackages = this.cacheService.getSentPackages(phone);
            Object session = this.sessionManagement.get(phone);
            byte[] idList = this.byteArrHelper.subByte(msgBody, 4);
            for (int i = 0; i < idList.length; i += 2) {
                int id = this.byteArrHelper.twobyte2int(new byte[]{idList[i], idList[i + 1]});
                byte[] pack = sentPackages.get(id);
                if (pack == null) continue;
                if (session instanceof IoSession) {
                    ((IoSession)session).write((Object)pack);
                    continue;
                }
                ((ChannelHandlerContext)session).writeAndFlush((Object)pack);
            }
        });
        return this.resHelper.getPlatAnswer(phoneNum, streamNum, msgId, (byte)0);
    }

    public Handler0x0005(CacheService cacheService, SessionManagement sessionManagement, ThreadPoolExecutor tpe, ByteArrHelper byteArrHelper, ResHelper resHelper) {
        this.cacheService = cacheService;
        this.sessionManagement = sessionManagement;
        this.tpe = tpe;
        this.byteArrHelper = byteArrHelper;
        this.resHelper = resHelper;
    }
}

