/*
 * Decompiled with CFR 0.152.
 */
package com.zhoyq.server.jt808.starter.netty.coder;

import com.zhoyq.server.jt808.starter.helper.ByteArrHelper;
import com.zhoyq.server.jt808.starter.helper.Jt808Helper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.util.AttributeKey;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class Jt808NettyDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private static final Logger log = LoggerFactory.getLogger(Jt808NettyDecoder.class);
    private static final AttributeKey<ByteBuf> BUFFER = AttributeKey.valueOf((String)"buffer");
    private static final byte MSG_BROKER = 126;
    private static final int MSG_MIN_LEN = 15;
    private static final int MEG_MIN_LEN_WITH_PKG = 19;
    private Jt808Helper jt808Helper;
    private ByteArrHelper byteArrHelper;

    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        boolean usingSessionBuffer = true;
        ByteBuf buf = (ByteBuf)ctx.channel().attr(BUFFER).get();
        if (buf != null) {
            boolean appended = false;
            if (buf.writableBytes() > 0) {
                try {
                    buf.writeBytes(ByteBufUtil.getBytes((ByteBuf)msg));
                    appended = true;
                }
                catch (IllegalStateException | IndexOutOfBoundsException e) {
                    log.warn(e.getMessage());
                }
            }
            if (appended) {
                buf.nioBuffer().flip();
            } else {
                buf.nioBuffer().flip();
                ByteBuf newBuf = ByteBufAllocator.DEFAULT.buffer(buf.readableBytes() + msg.readableBytes());
                newBuf.writeBytes(ByteBufUtil.getBytes((ByteBuf)buf));
                newBuf.writeBytes(ByteBufUtil.getBytes((ByteBuf)msg));
                buf = newBuf;
                ctx.channel().attr(BUFFER).set((Object)newBuf);
            }
        } else {
            buf = msg;
            usingSessionBuffer = false;
        }
        do {
            int oldPos = buf.readerIndex();
            boolean decoded = this.doDecode(ctx, buf, out);
            if (!decoded) break;
            if (buf.readerIndex() != oldPos) continue;
            throw new IllegalStateException("doDecode() can't return true when buffer is not consumed.");
        } while (buf.readableBytes() > 0);
        if (buf.readableBytes() > 0) {
            if (usingSessionBuffer && buf.writableBytes() > 0) {
                buf.nioBuffer().compact();
            } else {
                this.storeRemainingInSession(buf, ctx);
            }
        } else if (usingSessionBuffer) {
            this.removeSessionBuffer(ctx);
        }
    }

    private void removeSessionBuffer(ChannelHandlerContext ctx) {
        ctx.channel().attr(BUFFER).set(null);
    }

    private void storeRemainingInSession(ByteBuf buf, ChannelHandlerContext ctx) {
        ctx.channel().attr(BUFFER).set((Object)buf);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean doDecode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) {
        if (msg.readableBytes() <= 0) return false;
        msg.markReaderIndex();
        byte byteBuf = msg.readByte();
        if (byteBuf == 126) {
            msg.resetReaderIndex();
            byte[] bodyProp = new byte[5];
            msg.markReaderIndex();
            msg.readBytes(bodyProp, 0, 5);
            byte[] body = new byte[]{bodyProp[3], bodyProp[4]};
            int sizeBuf = this.jt808Helper.getMsgBodyLength(body);
            boolean b = this.jt808Helper.hasPackage(body);
            int size = b ? sizeBuf + 19 : sizeBuf + 15;
            msg.resetReaderIndex();
            log.trace("the real pkg length is {}", (Object)size);
            if (size <= msg.readableBytes() && size >= 15) {
                byte[] bytes = new byte[size];
                msg.readBytes(bytes, 0, size);
                if (bytes[bytes.length - 1] == 126) {
                    log.trace("origin data {} {}", (Object)this.byteArrHelper.toHexString(bytes), (Object)ctx.channel().remoteAddress());
                    bytes = this.jt808Helper.retrans(bytes);
                    if (this.jt808Helper.verify(bytes)) {
                        out.add(bytes);
                        if (msg.readableBytes() <= 0) return false;
                        return true;
                    }
                    if (msg.readableBytes() <= 0) return false;
                    return true;
                }
                log.trace("wrong data to drop {} {}", (Object)this.byteArrHelper.toHexString(bytes), (Object)ctx.channel().remoteAddress());
                if (msg.readableBytes() <= 0) return false;
                return true;
            }
        } else {
            log.trace("wrong data structure {}", (Object)ctx.channel().remoteAddress());
            int i = 0;
            do {
                if (i >= msg.readableBytes()) return false;
            } while (msg.readByte() != 126);
            return true;
        }
        msg.markReaderIndex();
        byte[] bytes = new byte[msg.readableBytes()];
        msg.readBytes(bytes, 0, msg.readableBytes());
        msg.resetReaderIndex();
        log.trace("short data length {} data {} go to reread {} ", new Object[]{msg.readableBytes(), this.byteArrHelper.toHexString(bytes), ctx.channel().remoteAddress()});
        return false;
    }

    public Jt808NettyDecoder(Jt808Helper jt808Helper, ByteArrHelper byteArrHelper) {
        this.jt808Helper = jt808Helper;
        this.byteArrHelper = byteArrHelper;
    }
}

