/*
 * Decompiled with CFR 0.152.
 */
package com.zhoyq.server.jt808.starter.netty;

import com.zhoyq.server.jt808.starter.config.Jt808Config;
import com.zhoyq.server.jt808.starter.core.Jt808Server;
import com.zhoyq.server.jt808.starter.netty.NettySessionHandler;
import com.zhoyq.server.jt808.starter.netty.coder.Jt808NettyDecoder;
import com.zhoyq.server.jt808.starter.netty.coder.Jt808NettyEncoder;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="jt808_netty_udp")
public class Jt808NettyUdpServer
implements Jt808Server {
    private static final Logger log = LoggerFactory.getLogger(Jt808NettyUdpServer.class);
    private static Channel serverChannel;
    private Jt808Config jt808Config;
    private NettySessionHandler handler;
    private Jt808NettyEncoder encoder;
    private Jt808NettyDecoder decoder;

    @Override
    public boolean start() {
        if (serverChannel != null) {
            return serverChannel.isActive();
        }
        NioEventLoopGroup masterGroup = new NioEventLoopGroup(this.jt808Config.getMasterSize().intValue());
        Bootstrap serverBootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)serverBootstrap.group((EventLoopGroup)masterGroup)).channel(NioDatagramChannel.class)).option(ChannelOption.SO_BROADCAST, (Object)true)).handler((ChannelHandler)new ChannelInitializer<NioDatagramChannel>(){

            protected void initChannel(NioDatagramChannel channel) throws Exception {
                channel.pipeline().addLast(new ChannelHandler[]{Jt808NettyUdpServer.this.encoder});
                channel.pipeline().addLast(new ChannelHandler[]{Jt808NettyUdpServer.this.decoder});
                channel.pipeline().addLast(new ChannelHandler[]{Jt808NettyUdpServer.this.handler});
            }
        });
        ChannelFuture channelFuture = serverBootstrap.bind(this.jt808Config.getPort().intValue());
        serverChannel = channelFuture.channel();
        return true;
    }

    @Override
    public boolean stop() {
        serverChannel.close();
        return true;
    }

    public Jt808NettyUdpServer(Jt808Config jt808Config, NettySessionHandler handler, Jt808NettyEncoder encoder, Jt808NettyDecoder decoder) {
        this.jt808Config = jt808Config;
        this.handler = handler;
        this.encoder = encoder;
        this.decoder = decoder;
    }
}

