/*
 * Decompiled with CFR 0.152.
 */
package com.zhoyq.server.jt808.starter.netty;

import com.zhoyq.server.jt808.starter.config.Jt808Config;
import com.zhoyq.server.jt808.starter.core.Jt808Server;
import com.zhoyq.server.jt808.starter.netty.NettySessionHandler;
import com.zhoyq.server.jt808.starter.netty.coder.Jt808NettyDecoder;
import com.zhoyq.server.jt808.starter.netty.coder.Jt808NettyEncoder;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="jt808_netty_tcp")
public class Jt808NettyTcpServer
implements Jt808Server {
    private static final Logger log = LoggerFactory.getLogger(Jt808NettyTcpServer.class);
    private static ServerChannel serverChannel;
    private static EventLoopGroup masterGroup;
    private static EventLoopGroup slaveGroup;
    private Jt808Config jt808Config;
    private NettySessionHandler handler;
    private Jt808NettyEncoder encoder;
    private Jt808NettyDecoder decoder;

    @Override
    public boolean start() {
        if (serverChannel != null) {
            return serverChannel.isActive();
        }
        masterGroup = new NioEventLoopGroup(this.jt808Config.getMasterSize().intValue());
        slaveGroup = new NioEventLoopGroup(this.jt808Config.getSlaveSize().intValue());
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)serverBootstrap.group(masterGroup, slaveGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel socketChannel) throws Exception {
                socketChannel.pipeline().addLast(new ChannelHandler[]{Jt808NettyTcpServer.this.encoder});
                socketChannel.pipeline().addLast(new ChannelHandler[]{Jt808NettyTcpServer.this.decoder});
                socketChannel.pipeline().addLast(new ChannelHandler[]{Jt808NettyTcpServer.this.handler});
            }
        }).childOption(ChannelOption.TCP_NODELAY, (Object)this.jt808Config.getTcpNoDelay()).childOption(ChannelOption.SO_KEEPALIVE, (Object)this.jt808Config.getKeepAlive());
        ChannelFuture channelFuture = serverBootstrap.bind(this.jt808Config.getPort().intValue());
        serverChannel = (ServerChannel)channelFuture.channel();
        return true;
    }

    @Override
    public boolean stop() {
        serverChannel.close();
        masterGroup.shutdownGracefully();
        slaveGroup.shutdownGracefully();
        return true;
    }

    public Jt808NettyTcpServer(Jt808Config jt808Config, NettySessionHandler handler, Jt808NettyEncoder encoder, Jt808NettyDecoder decoder) {
        this.jt808Config = jt808Config;
        this.handler = handler;
        this.encoder = encoder;
        this.decoder = decoder;
    }
}

