/*
 * Decompiled with CFR 0.152.
 */
package com.zhoyq.server.jt808.starter.mina.coder;

import com.zhoyq.server.jt808.starter.helper.ByteArrHelper;
import com.zhoyq.server.jt808.starter.helper.Jt808Helper;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class Jt808Decoder
extends CumulativeProtocolDecoder {
    private static final Logger log = LoggerFactory.getLogger(Jt808Decoder.class);
    private Jt808Helper jt808Helper;
    private ByteArrHelper byteArrHelper;
    private static final byte MSG_BROKER = 126;
    private static final int MSG_MIN_LEN = 15;
    private static final int MEG_MIN_LEN_WITH_PKG = 19;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean doDecode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) {
        if (in.remaining() <= 0) return false;
        in.mark();
        byte byteBuf = in.get();
        if (byteBuf == 126) {
            in.reset();
            byte[] bodyProp = new byte[5];
            in.mark();
            in.get(bodyProp, 0, 5);
            byte[] body = new byte[]{bodyProp[3], bodyProp[4]};
            int sizeBuf = this.jt808Helper.getMsgBodyLength(body);
            boolean b = this.jt808Helper.hasPackage(body);
            int size = b ? sizeBuf + 19 : sizeBuf + 15;
            in.reset();
            log.trace("the real pkg length is " + size);
            if (size <= in.remaining() && size >= 15) {
                byte[] bytes = new byte[size];
                in.get(bytes, 0, size);
                if (bytes[bytes.length - 1] == 126) {
                    log.trace("origin data " + this.byteArrHelper.toHexString(bytes) + " " + session.getRemoteAddress());
                    bytes = this.jt808Helper.retrans(bytes);
                    if (this.jt808Helper.verify(bytes)) {
                        out.write((Object)bytes);
                        if (in.remaining() <= 0) return false;
                        return true;
                    }
                    if (in.remaining() <= 0) return false;
                    return true;
                }
                log.trace("wrong data to drop " + this.byteArrHelper.toHexString(bytes) + " " + session.getRemoteAddress());
                if (in.remaining() <= 0) return false;
                return true;
            }
        } else {
            log.trace("wrong data structure " + session.getRemoteAddress());
            int i = 0;
            do {
                if (i >= in.remaining()) return false;
            } while (in.get() != 126);
            return true;
        }
        in.mark();
        byte[] bytes = new byte[in.remaining()];
        in.get(bytes, 0, in.remaining());
        in.reset();
        log.trace("short data length " + in.remaining() + " data " + this.byteArrHelper.toHexString(bytes) + " go to reread " + session.getRemoteAddress());
        return false;
    }

    public Jt808Decoder(Jt808Helper jt808Helper, ByteArrHelper byteArrHelper) {
        this.jt808Helper = jt808Helper;
        this.byteArrHelper = byteArrHelper;
    }
}

